/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.config.sections.security;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.rest.ui.model.ComplexEObjectListDataProvider;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.UserImagePanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.config.SettingsPage;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersPackage;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersConfigSection
extends BasicPanel<UserManagement> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UsersConfigSection.class);

    public UsersConfigSection(String id, IModel<UserManagement> model) {
        super(id, model);
        ComplexEObjectListDataProvider provider = new ComplexEObjectListDataProvider(model, (EStructuralFeature)UsersPackage.Literals.USER_MANAGEMENT__USERS);
        ListView<User> userList = new ListView<User>("user.row", provider){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<User> item) {
                item.add(new Component[]{new UserImagePanel("username", (IModel<User>)item.getModel())});
                item.add(new Component[]{new Label("roles", UsersConfigSection.this.buildRoles((User)item.getModelObject()))});
                PageParameters params = new PageParameters(this.getPage().getPageParameters());
                params.set(params.getIndexedCount(), (Object)"users");
                String name = ((User)item.getModelObject()).getName();
                if (name == null) {
                    name = "";
                }
                params.set(params.getIndexedCount(), (Object)name);
                item.add(new Component[]{new BookmarkablePageLink("edit", SettingsPage.class, params)});
                item.add(new Component[]{new Link<User>("delete", item.getModel()){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        try {
                            TransactionUtil.deleteWithCrossRefs((CDOObject)((CDOObject)this.getModelObject()), (EReference[])new EReference[0]);
                        }
                        catch (CommitException e) {
                            this.getSession().error((Serializable)((Object)e.getMessage()));
                            logger.error("Failed to commit", (Throwable)e);
                        }
                    }
                }});
            }
        };
        userList.setReuseItems(true);
        this.add(new Component[]{userList});
        this.add(new Component[]{this.buildAddNewLink((IModel<UserManagement>)this.getModel())});
    }

    protected String buildRoles(User modelObject) {
        StringBuilder builder = new StringBuilder();
        for (Role role : modelObject.getRoles()) {
            builder.append(role.getName());
            builder.append(", ");
        }
        if (builder.length() > 2) {
            builder.setLength(builder.length() - 2);
        }
        return builder.toString();
    }

    private Component buildAddNewLink(IModel<UserManagement> model) {
        PageParameters params = new PageParameters();
        UserManagement project = (UserManagement)model.getObject();
        if (project.cdoState() == CDOState.NEW || project.cdoState() == CDOState.TRANSIENT) {
            Button link = new Button("addNew");
            link.setEnabled(false);
            return link;
        }
        params.set(0, (Object)"security");
        params.add("create", (Object)UsersPackage.Literals.USER.getName());
        params.add("namespace", (Object)"http://uri.jabylon.org/users");
        return new BookmarkablePageLink("addNew", SettingsPage.class, params);
    }

    public static class UsersConfigSectionContributor
    extends AbstractConfigSection<UserManagement> {
        private static final long serialVersionUID = 1L;

        @Override
        public WebMarkupContainer doCreateContents(String id, IModel<UserManagement> input, Preferences config) {
            return new UsersConfigSection(id, input);
        }

        @Override
        public void commit(IModel<UserManagement> input, Preferences config) {
        }

        @Override
        public String getRequiredPermission() {
            return "User:*:config";
        }
    }
}

