/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.injector;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGiProxyTargetLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private String typeName;
    private boolean isList;

    public OSGiProxyTargetLocator(Class<?> clazz, boolean isList) {
        this.typeName = clazz.getName();
        this.isList = isList;
    }

    public Object locateProxyTarget() {
        if (this.isList) {
            return this.getAllServices();
        }
        return this.getSingleService();
    }

    private List<?> getAllServices() {
        Bundle bundle = FrameworkUtil.getBundle(OSGiProxyTargetLocator.class);
        BundleContext context = bundle.getBundleContext();
        try {
            ServiceReference[] references = context.getAllServiceReferences(this.typeName, null);
            if (references != null && references.length > 0) {
                ArrayList<Object> services = new ArrayList<Object>(references.length);
                for (ServiceReference serviceReference : references) {
                    Object service = context.getService(serviceReference);
                    if (service == null) continue;
                    services.add(service);
                }
                if (!services.isEmpty()) {
                    return services;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object getSingleService() {
        Bundle bundle = FrameworkUtil.getBundle(OSGiProxyTargetLocator.class);
        BundleContext context = bundle.getBundleContext();
        ServiceReference reference = context.getServiceReference(this.typeName);
        if (reference != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("Service " + this.typeName + " is not available");
    }
}

