/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.jabylon.rest.ui.navbar.NavbarPanel;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.wicket.FaviconHeaderItem;
import org.jabylon.rest.ui.wicket.JabylonApplication;
import org.jabylon.rest.ui.wicket.components.CustomFeedbackPanel;
import org.jabylon.rest.ui.wicket.components.IAjaxFeedbackPage;

public abstract class GenericPage<T>
extends WebPage
implements IAjaxFeedbackPage {
    private static final long serialVersionUID = 1L;
    private boolean constructed;
    private IModel<T> model;
    private CustomFeedbackPanel feedbackPanel;

    public GenericPage(PageParameters parameters) {
        super(parameters);
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JabylonApplication.get().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_BOOTSTRAP)));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)GlobalResources.MAIN_CSS));
        response.render((HeaderItem)new FaviconHeaderItem(GlobalResources.IMG_JABYLON_FAVICON));
        super.renderHead(response);
    }

    protected final void onBeforeRender() {
        this.setStatelessHint(true);
        this.internalConstruct();
        this.onBeforeRenderPage();
        super.onBeforeRender();
    }

    protected void onBeforeRenderPage() {
    }

    private final void internalConstruct() {
        if (!this.constructed) {
            this.feedbackPanel = new CustomFeedbackPanel("feedbackPanel");
            this.feedbackPanel.setOutputMarkupId(true);
            this.add(new Component[]{this.feedbackPanel});
            this.setModel(this.createModel((T)this.getPageParameters()));
            this.add(new Component[]{new NavbarPanel<T>("navbar", this.getModel(), this.getPageParameters())});
            this.preConstruct();
            this.construct();
            this.constructed = true;
        }
    }

    protected void preConstruct() {
    }

    protected void construct() {
    }

    protected abstract IModel<T> createModel(PageParameters var1);

    public void setModel(IModel<T> model) {
        this.model = model;
    }

    protected IModel<T> createModel(T object) {
        return new Model((Serializable)object);
    }

    public IModel<T> getModel() {
        return this.model;
    }

    public T getModelObject() {
        if (this.model == null) {
            return null;
        }
        return (T)this.model.getObject();
    }

    public void detachModels() {
        super.detachModels();
        if (this.getModel() != null) {
            this.getModel().detach();
        }
    }

    @Override
    public void showFeedback(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedbackPanel});
        target.appendJavaScript((CharSequence)("$('#" + this.feedbackPanel.getMarkupId() + "').addClass('ajax')" + ".clearQueue().show().slideDown().delay(5000).slideUp().end().hide();"));
    }
}

