/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.common.util.URI;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.rest.ui.wicket.pages.GenericResolvablePage;
import org.jabylon.rest.ui.wicket.panels.BreadcrumbPanel;
import org.jabylon.rest.ui.wicket.panels.ProjectResourcePanel;
import org.jabylon.rest.ui.wicket.panels.PropertyEditorPanel;
import org.jabylon.rest.ui.wicket.panels.PropertyEditorSinglePanel;
import org.jabylon.rest.ui.wicket.panels.PropertyListPanel;

public class ResourcePage<T extends Resolvable<?, ?>>
extends GenericResolvablePage<T> {
    private static final long serialVersionUID = 1L;

    public ResourcePage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onBeforeRenderPage() {
        Resolvable object = (Resolvable)this.getModelObject();
        if (object instanceof PropertyFileDescriptor) {
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)object;
            if (this.getPageParameters().get("editor").toString("").equals("full")) {
                this.addOrReplace(new Component[]{new PropertyEditorPanel(descriptor, this.getPageParameters())});
            } else if (this.getPageParameters().get("key").isEmpty()) {
                this.addOrReplace(new Component[]{new PropertyListPanel(descriptor, this.getPageParameters())});
            } else {
                this.addOrReplace(new Component[]{new PropertyEditorSinglePanel(descriptor, this.getPageParameters())});
            }
        } else {
            this.addOrReplace(new Component[]{new ProjectResourcePanel(object, this.getPageParameters())});
        }
    }

    @Override
    protected void construct() {
        BreadcrumbPanel breadcrumbPanel = new BreadcrumbPanel("breadcrumb-panel", this.getModel(), this.getPageParameters());
        this.add(new Component[]{breadcrumbPanel});
    }

    @Override
    protected T doLookup(List<String> segments) {
        ArrayList<String> modified = new ArrayList<String>(segments);
        if (segments.isEmpty() || !segments.get(0).equals("workspace")) {
            modified.add(0, "workspace");
        }
        URI uri = URI.createHierarchicalURI((String[])modified.toArray(new String[modified.size()]), null, null);
        return (T)((Resolvable)this.getLookup().resolve(uri));
    }
}

