/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.wicket.markup.html.link.StatelessLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.util.PropertyResourceUtil;
import org.jabylon.rest.ui.wicket.pages.ResourcePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteLink
extends StatelessLink<Void> {
    private static final long serialVersionUID = 8205155656605708520L;
    @Inject
    private URIResolver resolver;
    private static final Logger LOG = LoggerFactory.getLogger(DeleteLink.class);

    public DeleteLink(String id) {
        super(id);
    }

    public void onClick() {
        PropertyFileDescriptor descriptor = this.getModel(this.getPage().getPageParameters());
        if (descriptor != null) {
            try {
                ProjectLocale locale = (ProjectLocale)TransactionUtil.commit((EObject)descriptor, (Modification)new Modification<PropertyFileDescriptor, ProjectLocale>(){

                    public ProjectLocale apply(PropertyFileDescriptor object) {
                        ProjectLocale locale = object.getProjectLocale();
                        if (!object.isMaster()) {
                            object = object.getMaster();
                        }
                        if (object != null) {
                            PropertyResourceUtil.removeDescriptor((PropertyFileDescriptor)object);
                        }
                        return locale;
                    }
                });
                URI uri = this.resolver.getURI((Object)locale);
                PageParameters params = new PageParameters();
                for (int i = 0; i < uri.segmentCount(); ++i) {
                    params.set(i, (Object)uri.segment(i));
                }
                this.setResponsePage(ResourcePage.class, params);
            }
            catch (CommitException e) {
                this.error((Serializable)((Object)e.getMessage()));
                LOG.error("Failed to delete descriptor", (Throwable)e);
            }
        }
    }

    private PropertyFileDescriptor getModel(PageParameters pageParameters) {
        URI uri = URI.createURI((String)"/");
        for (int i = 0; i < pageParameters.getIndexedCount(); ++i) {
            uri = uri.appendSegment(pageParameters.get(i).toString());
        }
        return (PropertyFileDescriptor)this.resolver.resolve(uri);
    }
}

