/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.Review;
import org.jabylon.properties.ReviewState;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.model.ComplexEObjectListDataProvider;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.BasicResolvablePanel;
import org.jabylon.rest.ui.wicket.panels.ImageSwitch;
import org.jabylon.rest.ui.wicket.panels.LabelSwitch;
import org.jabylon.rest.ui.wicket.panels.LinkTarget;
import org.jabylon.rest.ui.wicket.panels.Summary;
import org.jabylon.rest.ui.wicket.panels.Triplet;
import org.jabylon.security.CommonPermissions;

public class ProjectResourcePanel
extends BasicResolvablePanel<Resolvable<?, ?>>
implements RestrictedComponent {
    private static final long serialVersionUID = 1L;

    public ProjectResourcePanel(Resolvable<?, ?> object, PageParameters parameters) {
        super("content", object, parameters);
        Project project;
        String announcement;
        if (object instanceof Project && (announcement = (project = (Project)object).getAnnouncement()) != null && !announcement.isEmpty()) {
            this.info((Serializable)((Object)announcement));
        }
        this.add(new Component[]{new Label("header", (String)new LabelSwitch(this.getLocale()).doSwitch((EObject)object))});
        String href = WicketUtil.getContextPath() + "/api/" + ((Resolvable)this.getModelObject()).toURI().appendQuery("type=file");
        ExternalLink downloadLink = new ExternalLink("download.link", href);
        downloadLink.setVisible(object != null && !(object instanceof Workspace) && !(object instanceof Project));
        this.add(new Component[]{downloadLink});
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_JQUERY_DATATABLES));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_BOOTSTRAP_DATATABLES));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_DATATABLES_CUSTOMSORT));
        super.renderHead(response);
    }

    @Override
    protected void onBeforeRenderPanel() {
        ComplexEObjectListDataProvider provider = new ComplexEObjectListDataProvider((IModel<? extends CDOObject>)this.getModel(), (EStructuralFeature)PropertiesPackage.Literals.RESOLVABLE__CHILDREN);
        final boolean endsOnSlash = this.urlEndsOnSlash();
        DataView dataView = new DataView<Resolvable<?, ?>>("children", provider){
            private static final long serialVersionUID = -3530355534807668227L;

            protected void populateItem(Item<Resolvable<?, ?>> item) {
                ProjectLocale locale;
                Resolvable resolvable = (Resolvable)item.getModelObject();
                if (resolvable instanceof ProjectLocale && (locale = (ProjectLocale)resolvable).isMaster()) {
                    item.setVisible(false);
                }
                LinkTarget target = ProjectResourcePanel.this.buildLinkTarget(resolvable, endsOnSlash);
                ExternalLink link = new ExternalLink("link", (IModel)Model.of((Serializable)((Object)target.getHref())), target.getLabel());
                item.add(new Component[]{link});
                Triplet widths = ProjectResourcePanel.this.computeProgressBars(target.getEndPoint());
                Label progress = new Label("progress", String.valueOf(widths.getSuccess()) + "%");
                progress.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width: " + widths.getSuccess() + "%")))});
                Label warning = new Label("warning", "");
                warning.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width: " + widths.getWarning() + "%")))});
                Label danger = new Label("danger", "");
                danger.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("width: " + widths.getDanger() + "%")))});
                item.add(new Component[]{progress});
                item.add(new Component[]{warning});
                item.add(new Component[]{danger});
                new ImageSwitch(item).doSwitch((EObject)target.getEndPoint());
                item.add(new Component[]{new Label("summary", (IModel)new Summary((Component)item).doSwitch((EObject)target.getEndPoint()))});
            }
        };
        this.add(new Component[]{dataView});
    }

    protected Triplet computeProgressBars(Resolvable<?, ?> resolvable) {
        int greenWidth = resolvable.getPercentComplete();
        int yellowWidth = 0;
        if (resolvable instanceof PropertyFileDescriptor) {
            int keys;
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)resolvable;
            int n = keys = descriptor.getMaster() == null ? descriptor.getKeys() : descriptor.getMaster().getKeys();
            if (keys > 0) {
                EList reviews = descriptor.getReviews();
                int activeReviews = 0;
                for (Review review : reviews) {
                    if (review.getState() != ReviewState.OPEN && review.getState() != ReviewState.REOPENED) continue;
                    ++activeReviews;
                }
                yellowWidth = (int)((double)(activeReviews * 100) / (double)keys);
                greenWidth -= yellowWidth;
            }
        }
        return new Triplet(greenWidth, yellowWidth);
    }

    private LinkTarget buildLinkTarget(Resolvable<?, ?> resolvable, boolean endsOnSlash) {
        StringBuilder hrefBuilder = new StringBuilder();
        LabelSwitch labelSwitch = new LabelSwitch(this.getLocale());
        StringBuilder name = new StringBuilder();
        name.append((String)labelSwitch.doSwitch((EObject)resolvable));
        if (resolvable.getParent() == null) {
            hrefBuilder.append("/");
        } else if (resolvable.getParent() instanceof Workspace) {
            hrefBuilder.append(endsOnSlash ? resolvable.getName() : "workspace/" + resolvable.getName());
        } else {
            hrefBuilder.append(endsOnSlash ? resolvable.getName() : resolvable.getParent().getName() + "/" + resolvable.getName());
        }
        Resolvable folder = resolvable;
        if (folder instanceof ResourceFolder) {
            while (folder.getChildren().size() == 1) {
                folder = (Resolvable)folder.getChildren().get(0);
                hrefBuilder.append("/");
                hrefBuilder.append(folder.getName());
                name.append("/");
                name.append((String)labelSwitch.doSwitch((EObject)folder));
            }
        }
        LinkTarget target = new LinkTarget((IModel<String>)Model.of((Serializable)((Object)name.toString())), hrefBuilder.toString(), folder);
        return target;
    }

    @Override
    public String getRequiredPermission() {
        for (Resolvable object = (Resolvable)this.getModelObject(); object != null; object = object.getParent()) {
            if (object instanceof Project) {
                return CommonPermissions.constructPermissionName((Resolvable)object, (String)"view");
            }
            if (!(object instanceof Workspace)) continue;
            return CommonPermissions.constructPermissionName((Resolvable)object, (String)"view");
        }
        return null;
    }
}

