/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.tools.PropertyEditorTool;
import org.jabylon.rest.ui.tools.PropertyToolTab;
import org.jabylon.rest.ui.wicket.BasicResolvablePanel;
import org.jabylon.rest.ui.wicket.components.BootstrapAjaxTabbedPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesEditorToolbar
extends BasicResolvablePanel<PropertyFileDescriptor> {
    private static final long serialVersionUID = 1L;
    private String currentKey;
    @Inject
    private List<PropertyEditorTool> tools;
    private PropertyPersistenceService persistenceService;
    private BootstrapAjaxTabbedPanel<PropertyToolTab> tabContainer;
    private List<PropertyToolTab> extensions;
    private static final Logger logger = LoggerFactory.getLogger(PropertiesEditorToolbar.class);

    public PropertiesEditorToolbar(String id, IModel<PropertyFileDescriptor> model, PageParameters pageParameters) {
        super(id, model, pageParameters);
    }

    @Override
    protected void construct() {
        this.extensions = this.createExtensions();
        this.tabContainer = new BootstrapAjaxTabbedPanel<PropertyToolTab>("tabs", this.extensions, "propertyTools/activeTab");
        this.add(new Component[]{this.tabContainer});
    }

    private List<PropertyToolTab> createExtensions() {
        ArrayList<PropertyToolTab> extensions = new ArrayList<PropertyToolTab>(this.tools.size());
        Collections.sort(this.tools, new Comparator<PropertyEditorTool>(){

            @Override
            public int compare(PropertyEditorTool o1, PropertyEditorTool o2) {
                return o1.getPrecedence() - o2.getPrecedence();
            }
        });
        for (PropertyEditorTool tool : this.tools) {
            extensions.add(new PropertyToolTab(tool));
        }
        return extensions;
    }

    public void setKey(String key) {
        if (key != null && !key.isEmpty() && !key.equals(this.currentKey)) {
            PropertyFileDescriptor translation = (PropertyFileDescriptor)this.getModel().getObject();
            try {
                PropertyFile properties = this.persistenceService.loadProperties(translation);
                properties.getProperty(key);
                PropertyFileDescriptor master = translation.getMaster();
                PropertyFile masterFile = this.persistenceService.loadProperties(master);
                PropertyPair pair = new PropertyPair(masterFile.getProperty(key), properties.getProperty(key), translation.getVariant(), translation.cdoID());
                for (PropertyToolTab tool : this.extensions) {
                    tool.setModel((IModel<PropertyPair>)Model.of((Serializable)pair));
                }
            }
            catch (ExecutionException e) {
                logger.error("Failed to load property file", (Throwable)e);
            }
        }
        this.currentKey = key;
    }
}

