/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.eclipse.emf.common.util.EList;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.resources.persistence.PropertyPersistenceService;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.util.WebContextUrlResourceReference;
import org.jabylon.rest.ui.wicket.BasicResolvablePanel;
import org.jabylon.rest.ui.wicket.panels.PropertiesEditorToolbar;
import org.jabylon.rest.ui.wicket.panels.PropertyListMode;
import org.jabylon.rest.ui.wicket.panels.PropertyPairDataProvider;
import org.jabylon.rest.ui.wicket.panels.SinglePropertyEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PropertyEditorPanel
extends BasicResolvablePanel<PropertyFileDescriptor> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PropertyEditorPanel.class);
    IModel<Multimap<String, Review>> reviewModel;
    @Inject
    private PropertyPersistenceService propertyPersistence;

    public PropertyEditorPanel(PropertyFileDescriptor object, PageParameters parameters) {
        super("content", object, parameters);
        PropertyListMode mode = PropertyListMode.getByName(parameters.get("mode").toString("ALL"));
        this.addLinkList(mode);
        this.reviewModel = new LoadableDetachableModel<Multimap<String, Review>>(){
            private static final long serialVersionUID = 1L;

            protected Multimap<String, Review> load() {
                return PropertyEditorPanel.this.buildReviewMap((PropertyFileDescriptor)PropertyEditorPanel.this.getModelObject());
            }
        };
        PropertyPairDataProvider provider = new PropertyPairDataProvider(object, mode, this.reviewModel);
        List<PropertyPair> contents = provider.createContents();
        ListView<PropertyPair> properties = new ListView<PropertyPair>("repeater", contents){
            private static final long serialVersionUID = -7087485011138279358L;

            protected void populateItem(ListItem<PropertyPair> item) {
                IModel model = item.getModel();
                String key = ((PropertyPair)model.getObject()).getKey();
                Collection reviewList = ((Multimap)PropertyEditorPanel.this.reviewModel.getObject()).get((Object)key);
                item.add(new Component[]{new SinglePropertyEditor("row", (IModel<PropertyPair>)model, false, reviewList)});
            }
        };
        properties.setOutputMarkupId(true);
        Form<List<? extends PropertyPair>> form = new Form<List<? extends PropertyPair>>("properties-form", Model.ofList(contents)){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                super.onSubmit();
                IModel model = this.getModel();
                List list = (List)model.getObject();
                PropertyFileDescriptor descriptor = (PropertyFileDescriptor)PropertyEditorPanel.this.getModelObject();
                PropertyFile file = descriptor.loadProperties();
                Map map = file.asMap();
                for (PropertyPair pair : list) {
                    Property translation = pair.getTranslation();
                    if (translation == null) continue;
                    if (map.containsKey(translation.getKey())) {
                        Property property = (Property)map.get(translation.getKey());
                        property.setComment(translation.getComment());
                        property.setValue(translation.getValue());
                        continue;
                    }
                    file.getProperties().add((Object)translation);
                }
                PropertyEditorPanel.this.propertyPersistence.saveProperties(descriptor, file);
                this.getSession().info((Serializable)((Object)"Saved successfully"));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for property persistence", (Throwable)e);
                }
            }
        };
        this.add(new Component[]{form});
        form.add(new Component[]{new SubmitLink("properties-submit"){
            private static final long serialVersionUID = 1L;

            protected String getTriggerJavaScript() {
                return "";
            }
        }});
        form.add(new Component[]{properties});
        PropertiesEditorToolbar editorToolbar = new PropertiesEditorToolbar("properties-toolbar", (IModel<PropertyFileDescriptor>)this.getModel(), this.getPageParameters());
        editorToolbar.setOutputMarkupId(true);
        this.add(new Component[]{editorToolbar});
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_JQUERY_DATATABLES));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_BOOTSTRAP_DATATABLES));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_SHORTCUTS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new WebContextUrlResourceReference("js/propertyEditor.js")));
        super.renderHead(response);
    }

    private Multimap<String, Review> buildReviewMap(PropertyFileDescriptor object) {
        EList reviews = object.getReviews();
        ArrayListMultimap reviewMap = ArrayListMultimap.create((int)reviews.size(), (int)2);
        for (Review review : reviews) {
            reviewMap.put((Object)review.getKey(), (Object)review);
        }
        return reviewMap;
    }

    private void addLinkList(final PropertyListMode currentMode) {
        List<PropertyListMode> values = Arrays.asList(PropertyListMode.values());
        ListView<PropertyListMode> mode = new ListView<PropertyListMode>("view-mode", values){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<PropertyListMode> item) {
                String mode = ((PropertyListMode)((Object)item.getModelObject())).name().toLowerCase();
                BookmarkablePageLink link = new BookmarkablePageLink("link", this.getPage().getClass(), new PageParameters(PropertyEditorPanel.this.getPageParameters()).set("mode", (Object)mode));
                link.setBody((IModel)Model.of((Serializable)((Object)("Show " + mode))));
                item.add(new Component[]{link});
                if (item.getModelObject() == currentMode) {
                    item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"active"))});
                }
            }
        };
        this.add(new Component[]{mode});
    }
}

