/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.jabylon.properties.Review;
import org.jabylon.rest.ui.model.PropertyPair;

enum PropertyListMode implements Predicate<PropertyPair>
{
    ALL{

        @Override
        public boolean apply(PropertyPair pair, Collection<Review> reviews) {
            return true;
        }
    }
    ,
    MISSING{

        @Override
        public boolean apply(PropertyPair pair, Collection<Review> reviews) {
            return pair.getOriginal() == null || pair.getTranslated() == null || pair.getOriginal().isEmpty() || pair.getTranslated().isEmpty();
        }
    }
    ,
    FUZZY{

        @Override
        public boolean apply(PropertyPair pair, Collection<Review> reviews) {
            if (MISSING.apply(pair, reviews)) {
                return true;
            }
            return reviews != null && !reviews.isEmpty();
        }
    };


    public abstract boolean apply(PropertyPair var1, Collection<Review> var2);

    public boolean apply(PropertyPair pair) {
        return this.apply(pair, null);
    }

    public static PropertyListMode getByName(String name) {
        if (name == null || name.isEmpty()) {
            return ALL;
        }
        return PropertyListMode.valueOf(name.toUpperCase());
    }
}

