/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.rest.ui.model.EClassSortState;
import org.jabylon.rest.ui.model.EObjectModel;
import org.jabylon.rest.ui.model.PropertyPair;
import org.jabylon.rest.ui.wicket.panels.PropertyListMode;

class PropertyPairDataProvider
extends SortableDataProvider<PropertyPair, EClassSortState>
implements IFilterStateLocator<String> {
    private static final long serialVersionUID = 1L;
    private CompoundPropertyModel<PropertyFileDescriptor> model;
    private transient List<PropertyPair> contents;
    private String filterState;
    private PropertyListMode mode;
    private IModel<Multimap<String, Review>> reviewModel;

    public PropertyPairDataProvider(PropertyFileDescriptor descriptor, PropertyListMode mode, IModel<Multimap<String, Review>> reviewModel) {
        this.model = new CompoundPropertyModel(new EObjectModel<PropertyFileDescriptor>(descriptor));
        this.mode = mode;
        this.reviewModel = reviewModel;
    }

    public Iterator<? extends PropertyPair> iterator(long first, long count) {
        List<PropertyPair> contents = this.getList();
        return contents.subList((int)first, (int)first + (int)count).iterator();
    }

    private List<PropertyPair> getList() {
        if (this.contents == null) {
            this.contents = this.createContents();
        }
        return this.contents;
    }

    protected List<PropertyPair> createContents() {
        PropertyPair pair;
        PropertyFileDescriptor descriptor = (PropertyFileDescriptor)this.model.getObject();
        Multimap reviews = (Multimap)this.reviewModel.getObject();
        PropertyFileDescriptor master = descriptor.getMaster();
        Map translated = descriptor.loadProperties().asMap();
        PropertyFile templateFile = master.loadProperties();
        ArrayList<PropertyPair> contents = new ArrayList<PropertyPair>();
        for (Property property : templateFile.getProperties()) {
            String key;
            pair = new PropertyPair(property, (Property)translated.remove(property.getKey()), descriptor.getVariant(), descriptor.cdoID());
            if (!this.mode.apply(pair, reviews.get((Object)(key = pair.getKey())))) continue;
            contents.add(pair);
        }
        for (Property property : translated.values()) {
            pair = new PropertyPair(null, property, descriptor.getVariant(), descriptor.cdoID());
            if (!this.mode.apply(pair, reviews.get((Object)pair.getKey()))) continue;
            contents.add(pair);
        }
        return contents;
    }

    public long size() {
        return this.getList().size();
    }

    public IModel<PropertyPair> model(PropertyPair object) {
        return Model.of((Serializable)object);
    }

    public void setFilterState(String state) {
        this.filterState = state;
    }

    public String getFilterState() {
        return this.filterState;
    }
}

