/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.eclipse.emf.common.util.URI;
import org.jabylon.index.properties.QueryService;
import org.jabylon.index.properties.SearchResult;
import org.jabylon.rest.ui.util.WicketUtil;
import org.jabylon.rest.ui.wicket.pages.ResourcePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    @Inject
    private QueryService queryService;
    private static final Logger logger = LoggerFactory.getLogger(SearchResultPanel.class);

    public SearchResultPanel(String id, final SearchResult result, PageParameters parameters) {
        super(id);
        List<ScoreDoc> list = Arrays.asList(result.getTopDocs().scoreDocs);
        ListView<ScoreDoc> repeater = new ListView<ScoreDoc>("results", list){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ScoreDoc> item) {
                ScoreDoc doc = (ScoreDoc)item.getModelObject();
                try {
                    int startParam;
                    Document document = result.getSearcher().doc(doc.doc);
                    item.add(new Component[]{new Label("value", document.get("value"))});
                    String projectLabel = "{0} ({1})";
                    String projectName = document.get("project");
                    String projectVersion = document.get("version");
                    String projectLocale = document.get("locale");
                    String descriptorURI = document.get("uri");
                    PageParameters params = new PageParameters();
                    params.set(0, (Object)projectName);
                    params.set(1, (Object)projectVersion);
                    params.set(2, (Object)projectLocale);
                    URI uri = URI.createURI((String)descriptorURI);
                    for (int i = startParam = 3; i < uri.segmentCount() + startParam; ++i) {
                        params.set(i, (Object)uri.segment(i - startParam));
                    }
                    BookmarkablePageLink link = new BookmarkablePageLink("link", ResourcePage.class, params);
                    link.add(new Component[]{new Label("title", uri.lastSegment())});
                    item.add(new Component[]{link});
                    projectLabel = MessageFormat.format(projectLabel, projectName, projectVersion);
                    BookmarkablePageLink projectVersionLink = new BookmarkablePageLink("project-link", ResourcePage.class, SearchResultPanel.this.createPageParams(projectName, projectVersion));
                    projectVersionLink.add(new Component[]{new Label("project", projectLabel)});
                    item.add(new Component[]{projectVersionLink});
                    String key = document.get("key");
                    BookmarkablePageLink projectVersionKeyLink = new BookmarkablePageLink("key-link", ResourcePage.class, params.set("key", (Object)key));
                    projectVersionKeyLink.add(new Component[]{new Label("key", key)});
                    item.add(new Component[]{projectVersionKeyLink});
                    item.add(new Component[]{new Label("comment", document.get("comment"))});
                    item.add(new Component[]{new Label("mastervalue", document.get("masterValue"))});
                    item.add(new Component[]{new Label("mastercomment", document.get("masterComment"))});
                    Locale locale = WicketUtil.getLocaleFromString(projectLocale);
                    String localeLabel = locale.getDisplayName(WicketUtil.getUserLocale());
                    item.add(new Component[]{new Label("language", localeLabel)});
                    item.add(new Component[]{new Image("flag-icon", WicketUtil.getIconForLocale(locale))});
                }
                catch (CorruptIndexException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    logger.error("Search failed", (Throwable)e);
                }
                catch (IOException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    logger.error("Search failed", (Throwable)e);
                }
            }
        };
        this.add(new Component[]{repeater});
    }

    public QueryService getQueryService() {
        return this.queryService;
    }

    protected PageParameters createPageParams(String ... segments) {
        PageParameters params = new PageParameters();
        for (int i = 0; i < segments.length; ++i) {
            params.set(i, (Object)segments[i]);
        }
        return params;
    }
}

