/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.Review;
import org.jabylon.properties.Severity;
import org.jabylon.rest.ui.model.PropertyPair;

public class SinglePropertyEditor
extends GenericPanel<PropertyPair> {
    static final String OK_LABEL = "OK";
    private static final long serialVersionUID = 1L;
    private boolean expanded;

    public SinglePropertyEditor(String id, IModel<PropertyPair> model, boolean expanded, Collection<Review> reviews) {
        super(id, model);
        this.expanded = expanded;
        this.setOutputMarkupId(true);
        PropertyPair propertyPair = (PropertyPair)model.getObject();
        Property template = propertyPair.getTemplate();
        String key = null;
        key = template != null ? propertyPair.getTemplate().getKey() : propertyPair.getTranslation().getKey();
        Label icon = new Label("icon");
        icon.setOutputMarkupId(true);
        this.add(new Component[]{icon});
        this.fillStatusColumn(propertyPair, reviews);
        WebMarkupContainer templatePanel = new WebMarkupContainer("template-area");
        templatePanel.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)(this.isExpanded() ? "collapse in" : "collapse")))});
        templatePanel.setOutputMarkupId(true);
        this.add(new Component[]{templatePanel});
        WebMarkupContainer translationPanel = new WebMarkupContainer("translation-area");
        translationPanel.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)(this.isExpanded() ? "collapse in" : "collapse")))});
        translationPanel.setOutputMarkupId(true);
        this.add(new Component[]{translationPanel});
        Label translationLabel = new Label("translation-label", (IModel)new PropertyModel((Object)propertyPair, "translated"));
        WebMarkupContainer toggletButton = new WebMarkupContainer("toggle");
        this.add(new Component[]{toggletButton});
        this.add(new Component[]{new Label("key-label", key)});
        this.add(new Component[]{translationLabel});
        TextArea textArea = new TextArea("template", (IModel)new PropertyModel((Object)propertyPair, "original"));
        templatePanel.add(new Component[]{textArea});
        textArea = new TextArea("template-comment", (IModel)new PropertyModel((Object)propertyPair, "originalComment"));
        templatePanel.add(new Component[]{textArea});
        textArea = new TextArea("translation-comment", (IModel)new PropertyModel((Object)propertyPair, "translatedComment"));
        translationPanel.add(new Component[]{textArea});
        textArea = new TextArea("translation", (IModel)new PropertyModel((Object)propertyPair, "translated"));
        translationPanel.add(new Component[]{textArea});
    }

    protected void fillStatusColumn(PropertyPair propertyPair, Collection<Review> reviewCollection) {
        IStatus status = this.calculateRowStatus(propertyPair);
        if (status.getSeverity() == 2) {
            this.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"warning"))});
        } else if (status.getSeverity() == 4) {
            this.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"error"))});
        }
        Collection<Review> reviews = reviewCollection;
        if (reviews == null || reviews.isEmpty()) {
            reviews = this.createInMemoryReview(propertyPair);
        }
        RepeatingView view = new RepeatingView("reviews");
        for (Review review : reviews) {
            Label label = new Label(view.newChildId(), review.getReviewType());
            label.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)this.getLabelClass(review)))});
            if (review.getMessage() != null) {
                label.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)review.getMessage()))});
            }
            view.add(new Component[]{label});
        }
        this.add(new Component[]{view});
    }

    private List<Review> createInMemoryReview(PropertyPair pair) {
        if (pair.getTranslated() == null || pair.getTranslated().isEmpty()) {
            Review review = PropertiesFactory.eINSTANCE.createReview();
            String message = "The key ''{0}'' is not yet translated";
            review.setMessage(MessageFormat.format(message, pair.getKey()));
            review.setReviewType("Missing Translation");
            review.setSeverity(Severity.ERROR);
            return Collections.singletonList(review);
        }
        Review review = PropertiesFactory.eINSTANCE.createReview();
        review.setReviewType(OK_LABEL);
        return Collections.singletonList(review);
    }

    protected String getLabelClass(Review review) {
        if (review.getReviewType().equals(OK_LABEL)) {
            return " label-success";
        }
        Severity severity = review.getSeverity();
        switch (severity) {
            case ERROR: {
                return " label-important";
            }
            case INFO: {
                return " label-info";
            }
            case WARNING: {
                return " label-warning";
            }
        }
        return "";
    }

    private IStatus calculateRowStatus(PropertyPair propertyPair) {
        if (propertyPair.getOriginal() == null || propertyPair.getOriginal().isEmpty()) {
            return new Status(4, "org.jabylon.rest.ui", "");
        }
        if (propertyPair.getTranslated() == null || propertyPair.getTranslated().isEmpty()) {
            return new Status(4, "org.jabylon.rest.ui", "");
        }
        return Status.OK_STATUS;
    }

    public boolean isExpanded() {
        return this.expanded;
    }
}

