/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.rest.ui.wicket.panels;

import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.util.PropertiesSwitch;

class Summary
extends PropertiesSwitch<IModel<String>> {
    private static final String NUMBER_OF_KEYS_KEY = "number.of.keys";
    private static final String TRANSLATION_PERCENTAGE_KEY = "translation.percentage";
    private static final String TRANSLATION_PERCENTAGE_SHORT_KEY = "translation.percentage.short";
    private transient Component parent;

    public Summary(Component parent) {
        this.parent = parent;
    }

    public <P extends Resolvable<?, ?>, C extends Resolvable<?, ?>> IModel<String> caseResolvable(Resolvable<P, C> object) {
        return new StringResourceModel(TRANSLATION_PERCENTAGE_SHORT_KEY, this.parent, null, new Object[]{object.getPercentComplete()});
    }

    public IModel<String> caseProjectLocale(ProjectLocale object) {
        if (object.getParent() == null && ((ProjectVersion)object.getParent()).getTemplate() == null) {
            return null;
        }
        ProjectLocale template = ((ProjectVersion)object.getParent()).getTemplate();
        int propertyCount = template.getPropertyCount();
        int translatedCount = object.getPropertyCount();
        return new StringResourceModel(TRANSLATION_PERCENTAGE_KEY, this.parent, null, new Object[]{translatedCount, propertyCount, object.getPercentComplete()});
    }

    public IModel<String> casePropertyFileDescriptor(PropertyFileDescriptor object) {
        int propertyCount = object.getKeys();
        if (object.isMaster()) {
            String message = NUMBER_OF_KEYS_KEY;
            message = MessageFormat.format(message, propertyCount);
            return new StringResourceModel(NUMBER_OF_KEYS_KEY, this.parent, null, new Object[]{propertyCount});
        }
        int templateCount = object.getMaster().getKeys();
        return new StringResourceModel(TRANSLATION_PERCENTAGE_KEY, this.parent, null, new Object[]{propertyCount, templateCount, object.getPercentComplete()});
    }
}

