/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.internal.net4j.buffer.BufferProvider;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferPool
extends BufferProvider
implements IBufferPool.Introspection {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER, BufferPool.class);
    private final IBufferProvider provider;
    private int pooledBuffers;
    @ReflectUtil.ExcludeFromDump
    private final Queue<BufferRef> buffers = new ConcurrentLinkedQueue<BufferRef>();
    @ReflectUtil.ExcludeFromDump
    private final ReferenceQueue<IBuffer> referenceQueue = new ReferenceQueue();
    @ReflectUtil.ExcludeFromDump
    private Monitor monitor;

    public BufferPool(IBufferProvider provider) {
        super(provider.getBufferCapacity());
        this.provider = provider;
    }

    public IBufferProvider getProvider() {
        return this.provider;
    }

    public ReferenceQueue<IBuffer> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public int getPooledBuffers() {
        return this.pooledBuffers;
    }

    @Override
    public boolean evictOne() {
        BufferRef bufferRef;
        IBuffer buffer;
        do {
            if ((bufferRef = this.buffers.poll()) != null) continue;
            return false;
        } while ((buffer = (IBuffer)bufferRef.get()) == null);
        if (TRACER.isEnabled()) {
            TRACER.trace("Evicting " + buffer);
        }
        this.provider.retainBuffer(buffer);
        --this.pooledBuffers;
        return true;
    }

    @Override
    public int evict(int survivors) {
        int evictedBuffers = 0;
        while (this.pooledBuffers > survivors) {
            if (!this.evictOne()) break;
            ++evictedBuffers;
        }
        return evictedBuffers;
    }

    @Override
    public String toString() {
        return MessageFormat.format("BufferPool[{0}]", this.getBufferCapacity());
    }

    protected BufferRef createBufferRef(IBuffer buffer) {
        return new BufferRef(buffer, this.referenceQueue);
    }

    @Override
    protected IBuffer doProvideBuffer() {
        IBuffer buffer = null;
        BufferRef bufferRef = this.buffers.poll();
        if (bufferRef != null) {
            buffer = (IBuffer)bufferRef.get();
        }
        if (buffer == null) {
            buffer = this.provider.provideBuffer();
            ((InternalBuffer)buffer).setBufferProvider(this);
        } else {
            --this.pooledBuffers;
        }
        buffer.clear();
        if (TRACER.isEnabled()) {
            TRACER.trace("Obtained " + buffer);
        }
        return buffer;
    }

    @Override
    protected void doRetainBuffer(IBuffer buffer) {
        if (buffer.getCapacity() != this.getBufferCapacity()) {
            throw new IllegalArgumentException("buffer.getCapacity() != getBufferCapacity()");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Retaining " + buffer);
        }
        BufferRef bufferRef = this.createBufferRef(buffer);
        this.buffers.add(bufferRef);
        ++this.pooledBuffers;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.monitor = new Monitor();
        this.monitor.start();
    }

    protected void doDeactivate() throws Exception {
        this.monitor.interrupt();
        this.monitor = null;
        super.doDeactivate();
    }

    static /* synthetic */ ContextTracer access$0() {
        return TRACER;
    }

    static /* synthetic */ Queue access$1(BufferPool bufferPool) {
        return bufferPool.buffers;
    }

    static /* synthetic */ int access$2(BufferPool bufferPool) {
        return bufferPool.pooledBuffers;
    }

    static /* synthetic */ void access$3(BufferPool bufferPool, int n) {
        bufferPool.pooledBuffers = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BufferRef
    extends SoftReference<IBuffer> {
        public BufferRef(IBuffer buffer, ReferenceQueue<IBuffer> queue) {
            super(buffer, queue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Monitor
    extends Thread {
        public Monitor() {
            this.setName("Net4jBufferPoolMonitor");
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (!BufferPool.access$0().isEnabled()) ** GOTO lbl12
            BufferPool.access$0().trace("Start monitoring");
            try {
                try {
                    if (true) ** GOTO lbl12
                    do {
                        if ((bufferRef = this.pollQueue()) != null && BufferPool.access$1(BufferPool.this).remove(bufferRef)) {
                            v0 = BufferPool.this;
                            BufferPool.access$3(v0, BufferPool.access$2(v0) - 1);
                            if (BufferPool.access$0().isEnabled()) {
                                BufferPool.access$0().trace("Collected buffer");
                            }
                        }
lbl12:
                        // 7 sources

                        if (!BufferPool.this.isActive()) return;
                    } while (!this.isInterrupted());
                    return;
                }
                catch (InterruptedException ex) {
                    if (!BufferPool.access$0().isEnabled()) return;
                    BufferPool.access$0().trace("Stop monitoring");
                    return;
                }
            }
            finally {
                if (BufferPool.access$0().isEnabled()) {
                    BufferPool.access$0().trace("Stop monitoring");
                }
            }
        }

        private Reference<? extends IBuffer> pollQueue() throws InterruptedException {
            return BufferPool.this.referenceQueue.remove(5000L);
        }
    }
}

