/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.Acceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportConfigurator {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TransportConfigurator.class);
    private IManagedContainer container;

    public TransportConfigurator(IManagedContainer container) {
        this.container = container;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public IAcceptor[] configure(File configFile) throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring Net4j server from " + configFile.getAbsolutePath());
        }
        ArrayList<IAcceptor> acceptors = new ArrayList<IAcceptor>();
        Document document = this.getDocument(configFile);
        NodeList acceptorConfigs = document.getElementsByTagName("acceptor");
        int i = 0;
        while (i < acceptorConfigs.getLength()) {
            Element acceptorConfig = (Element)acceptorConfigs.item(i);
            IAcceptor acceptor = this.configureAcceptor(acceptorConfig);
            acceptors.add(acceptor);
            ++i;
        }
        return acceptors.toArray(new IAcceptor[acceptors.size()]);
    }

    protected IAcceptor configureAcceptor(Element acceptorConfig) {
        String type = acceptorConfig.getAttribute("type");
        String listenAddr = acceptorConfig.getAttribute("listenAddr");
        String port = acceptorConfig.getAttribute("port");
        String description = String.valueOf(listenAddr == null ? "" : listenAddr) + (port == null ? "" : ":" + port);
        Acceptor acceptor = (Acceptor)this.container.getElement("org.eclipse.net4j.acceptors", type, description, false);
        NodeList negotiatorConfigs = acceptorConfig.getElementsByTagName("negotiator");
        if (negotiatorConfigs.getLength() > 1) {
            throw new IllegalStateException("A maximum of one negotiator can be configured for acceptor " + acceptor);
        }
        if (negotiatorConfigs.getLength() == 1) {
            Element negotiatorConfig = (Element)negotiatorConfigs.item(0);
            INegotiator negotiator = this.configureNegotiator(negotiatorConfig);
            acceptor.getConfig().setNegotiator(negotiator);
        }
        acceptor.activate();
        return acceptor;
    }

    protected INegotiator configureNegotiator(Element negotiatorConfig) {
        String type = negotiatorConfig.getAttribute("type");
        String description = negotiatorConfig.getAttribute("description");
        return (INegotiator)this.container.getElement("org.eclipse.net4j.Negotiators", type, description);
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected Element getStoreConfig(Element repositoryConfig) {
        NodeList storeConfigs = repositoryConfig.getElementsByTagName("store");
        if (storeConfigs.getLength() != 1) {
            String repositoryName = repositoryConfig.getAttribute("name");
            throw new IllegalStateException("Exactly one store must be configured for repository " + repositoryName);
        }
        return (Element)storeConfigs.item(0);
    }

    public static Map<String, String> getProperties(Element element, int levels) {
        HashMap<String, String> properties = new HashMap<String, String>();
        TransportConfigurator.collectProperties(element, "", properties, levels);
        return properties;
    }

    private static void collectProperties(Element element, String prefix, Map<String, String> properties, int levels) {
        if ("property".equals(element.getNodeName())) {
            String name = element.getAttribute("name");
            String value = element.getAttribute("value");
            properties.put(String.valueOf(prefix) + name, value);
            prefix = String.valueOf(prefix) + name + ".";
        }
        if (levels > 0) {
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element) {
                    TransportConfigurator.collectProperties((Element)childNode, prefix, properties, levels - 1);
                }
                ++i;
            }
        }
    }
}

