/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.resolver.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.resolver.URIHandler;
import org.jabylon.common.resolver.URIResolver;

@Component
@Service
public class URIResolverImpl
implements URIResolver {
    @Reference(referenceInterface=URIHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="addHandler", unbind="removeHandler", policy=ReferencePolicy.DYNAMIC)
    private List<URIHandler> handlers = new CopyOnWriteArrayList<URIHandler>();
    private CDONet4jSession session;
    private CDOView view;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private RepositoryConnector repositoryConnector;

    public void addHandler(URIHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(URIHandler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public Object resolve(URI uri) {
        for (URIHandler handler : this.handlers) {
            if (!handler.canHandle(uri)) continue;
            Object resolved = handler.resolve(uri);
            return resolved;
        }
        return null;
    }

    public URI internalGetURI(Object o) {
        for (URIHandler handler : this.handlers) {
            if (!handler.canHandle(o)) continue;
            return handler.toURI(o);
        }
        return null;
    }

    @Override
    public URI getURI(Object o) {
        URI uri = this.internalGetURI(o);
        if (uri == null) {
            return null;
        }
        return uri;
    }

    @Override
    public Object resolve(String path) {
        if (path == null) {
            return this.resolve((URI)null);
        }
        URI uri = URI.createURI((String)path, (boolean)true);
        return this.resolve(uri);
    }

    public void bindRepositoryConnector(RepositoryConnector connector) {
        this.session = connector.createSession();
        this.view = this.session.openView();
    }

    public void unbindRepositoryConnector(RepositoryConnector connector) {
        this.view.close();
        this.view = null;
        this.session.close();
        this.session = null;
    }

    @Deactivate
    public void deactivate() {
        if (this.view != null) {
            this.view.close();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    @Override
    public CDOObject resolve(CDOID id) {
        return this.view.getObject(id);
    }

    @Override
    public CDOObject resolveWithTransaction(CDOID id) {
        return this.session.openTransaction().getObject(id);
    }
}

