/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.resolver.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.resolver.URIHandler;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersPackage;

@Component
@Service
public class UserManagmentURIHandler
implements URIHandler {
    public static final String SECURITY_URI_PREFIX = "security";
    @Reference
    private RepositoryConnector repositoryConnector;
    private CDONet4jSession session;
    private UserManagement userManagment;

    @Activate
    public void activate() {
        this.session = this.repositoryConnector.createSession();
        CDOView view = this.session.openView();
        CDOResource userResource = view.getResource("users");
        this.userManagment = (UserManagement)userResource.getContents().get(0);
    }

    @Deactivate
    public void deactivate() {
        this.session.close();
    }

    @Override
    public Object resolve(URI uri) {
        if (uri == null || uri.isEmpty() || uri.segmentCount() == 0) {
            return null;
        }
        String firstSegment = uri.segment(0);
        if (SECURITY_URI_PREFIX.equals(firstSegment)) {
            List list = uri.segmentsList().subList(1, uri.segmentCount());
            Object parent = this.userManagment;
            for (String segment : list) {
                if ((parent = this.getChild(parent, URI.decode((String)segment))) != null) continue;
                return null;
            }
            return parent;
        }
        return null;
    }

    private Object getChild(Object parent, String segment) {
        EObject eobject;
        EStructuralFeature feature;
        if (parent instanceof Collection) {
            Collection list = (Collection)parent;
            for (Object object : list) {
                if (!this.matches(object, segment)) continue;
                return object;
            }
        } else if (parent instanceof EObject && (feature = (eobject = (EObject)parent).eClass().getEStructuralFeature(segment)) != null) {
            return eobject.eGet(feature);
        }
        return null;
    }

    private boolean matches(Object object, String segment) {
        if (object instanceof EObject) {
            EObject eobject = (EObject)object;
            String name = this.getSegmentName(eobject);
            if (name == null) {
                return false;
            }
            return name.equals(segment);
        }
        return false;
    }

    private String getSegmentName(EObject object) {
        if (object instanceof UserManagement) {
            return SECURITY_URI_PREFIX;
        }
        EStructuralFeature feature = object.eClass().getEStructuralFeature("name");
        if (feature == null) {
            return null;
        }
        return (String)object.eGet(feature);
    }

    public void bindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = connector;
    }

    public void unbindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = null;
    }

    @Override
    public boolean canHandle(URI uri) {
        if (uri == null || uri.isEmpty() || uri.segmentCount() == 0) {
            return false;
        }
        return SECURITY_URI_PREFIX.equals(uri.segment(0));
    }

    @Override
    public boolean canHandle(Object o) {
        if (o instanceof EObject) {
            EObject eobject = (EObject)o;
            return eobject.eClass().getEPackage().equals(UsersPackage.eINSTANCE);
        }
        if (o instanceof EStructuralFeature.Setting) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)o;
            return setting.getEStructuralFeature().getEType().getEPackage().equals(UsersPackage.eINSTANCE);
        }
        return false;
    }

    @Override
    public URI toURI(Object o) {
        ArrayDeque<String> segments = new ArrayDeque<String>();
        if (o instanceof EStructuralFeature.Setting) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)o;
            o = setting.getEObject();
            segments.add(setting.getEStructuralFeature().getName());
        }
        if (o instanceof EObject) {
            EObject object = (EObject)o;
            while (true) {
                segments.push(this.getSegmentName(object));
                EStructuralFeature eContainingFeature = object.eContainingFeature();
                if (eContainingFeature == null) break;
                segments.push(eContainingFeature.getName());
                object = object.eContainer();
            }
            StringBuilder builder = new StringBuilder();
            for (String segment : segments) {
                builder.append(segment);
                builder.append("/");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return URI.createURI((String)builder.toString());
        }
        return null;
    }
}

