/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.resolver.impl;

import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.resolver.URIHandler;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;

@Component
@Service
public class WorkspaceURIHandler
implements URIHandler {
    @Reference
    private RepositoryConnector repositoryConnector;
    private CDONet4jSession session;
    private Workspace workspace;

    @Activate
    public void activate() {
        this.session = this.repositoryConnector.createSession();
        CDOView view = this.session.openView();
        CDOResource workspaceResource = view.getResource("workspace");
        this.workspace = (Workspace)workspaceResource.getContents().get(0);
    }

    @Deactivate
    public void deactivate() {
        this.session.close();
    }

    @Override
    public Object resolve(URI uri) {
        if (uri == null || uri.isEmpty() || uri.segmentCount() == 0) {
            return this.workspace;
        }
        String firstSegment = uri.segment(0);
        if ("workspace".equals(firstSegment)) {
            List list = uri.segmentsList().subList(1, uri.segmentCount());
            URI relativeURI = URI.createHierarchicalURI((String[])list.toArray(new String[list.size()]), (String)uri.query(), (String)uri.fragment());
            return this.workspace.resolveChild(relativeURI);
        }
        return null;
    }

    public void bindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = connector;
    }

    public void unbindRepositoryConnector(RepositoryConnector connector) {
        this.repositoryConnector = null;
    }

    @Override
    public boolean canHandle(URI uri) {
        if (uri == null || uri.isEmpty() || uri.segmentCount() == 0) {
            return true;
        }
        return "workspace".equals(uri.segment(0));
    }

    @Override
    public boolean canHandle(Object o) {
        return o instanceof Resolvable;
    }

    @Override
    public URI toURI(Object o) {
        if (o instanceof Resolvable) {
            Resolvable r = (Resolvable)o;
            return r.toURI();
        }
        return null;
    }
}

