/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.review.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.resources.changes.PropertiesListener;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PropertyReviewService
implements PropertiesListener {
    @Reference(referenceInterface=ReviewParticipant.class, bind="addParticipant", unbind="removeParticipant", cardinality=ReferenceCardinality.MANDATORY_MULTIPLE)
    private List<ReviewParticipant> participants = Collections.synchronizedList(new ArrayList());
    private static final Logger logger = LoggerFactory.getLogger(PropertyReviewService.class);

    protected void addParticipant(ReviewParticipant pariticpant) {
        logger.info("Adding new review participant {} (ID: {})", (Object)pariticpant.getName(), (Object)pariticpant.getID());
        this.participants.add(pariticpant);
    }

    protected void removeParticipant(ReviewParticipant pariticpant) {
        logger.info("Deactivating review participant {} (ID: {})", (Object)pariticpant.getName(), (Object)pariticpant.getID());
        this.participants.remove(pariticpant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyFileAdded(PropertyFileDescriptor descriptor, boolean autoSync) {
        if (descriptor.isMaster()) {
            return;
        }
        Project project = (Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent();
        List<ReviewParticipant> activeReviews = this.getActiveReviews(project);
        if (activeReviews.isEmpty()) {
            return;
        }
        PropertyFile slaveProperties = descriptor.loadProperties();
        PropertyFile masterProperties = descriptor.getMaster().loadProperties();
        CDOTransaction transaction = descriptor.cdoView().getSession().openTransaction();
        descriptor = (PropertyFileDescriptor)transaction.getObject((EObject)descriptor);
        HashSet<String> allProperties = new HashSet<String>();
        for (Property prop : slaveProperties.getProperties()) {
            String key = prop.getKey();
            if (key == null) continue;
            allProperties.add(key);
            Property masterProperty = masterProperties.getProperty(key);
            for (ReviewParticipant reviewer : activeReviews) {
                Review review = null;
                review = descriptor.isMaster() ? reviewer.review(descriptor, prop, null) : reviewer.review(descriptor, masterProperty, prop);
                if (review == null) continue;
                review.setKey(prop.getKey());
                descriptor.getReviews().add((Object)review);
            }
        }
        if (!descriptor.isMaster()) {
            for (Property property : masterProperties.getProperties()) {
                if (allProperties.contains(property.getKey())) continue;
                for (ReviewParticipant reviewer : activeReviews) {
                    Review review = reviewer.review(descriptor, property, null);
                    if (review == null) continue;
                    review.setKey(property.getKey());
                    descriptor.getReviews().add((Object)review);
                }
            }
        }
        try {
            if (transaction.isDirty()) {
                transaction.commit();
            }
        }
        catch (CommitException e) {
            logger.error("Commit failed", (Throwable)e);
        }
        finally {
            transaction.close();
        }
    }

    private void removeKey(String key, List<Review> reviews) {
        Iterator<Review> it = reviews.iterator();
        while (it.hasNext()) {
            Review review = it.next();
            if (!key.equals(review.getKey())) continue;
            it.remove();
        }
    }

    public void propertyFileDeleted(PropertyFileDescriptor descriptor, boolean autoSync) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyFileModified(PropertyFileDescriptor descriptor, List<Notification> changes, boolean autoSync) {
        Project project = (Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent();
        List<ReviewParticipant> activeReviews = this.getActiveReviews(project);
        if (activeReviews.isEmpty()) {
            return;
        }
        CDOTransaction transaction = descriptor.cdoView().getSession().openTransaction();
        descriptor = (PropertyFileDescriptor)transaction.getObject((EObject)descriptor);
        PropertyFile masterProperties = null;
        if (!descriptor.isMaster()) {
            masterProperties = descriptor.getMaster().loadProperties();
        }
        for (Notification change : changes) {
            Object notifier = change.getNotifier();
            if (notifier instanceof Property) {
                Property prop = (Property)notifier;
                this.analyzeProperty(descriptor, activeReviews, masterProperties, prop);
                continue;
            }
            if (!(notifier instanceof PropertyFile)) continue;
            Object newValue = change.getNewValue();
            if (change.getEventType() == 3 && newValue instanceof Property) {
                Property property = (Property)newValue;
                this.analyzeProperty(descriptor, activeReviews, masterProperties, property);
                continue;
            }
            if (change.getEventType() != 5 || !(newValue instanceof Collection)) continue;
            Collection properties = (Collection)newValue;
            for (Property property : properties) {
                this.analyzeProperty(descriptor, activeReviews, masterProperties, property);
            }
        }
        try {
            if (transaction.isDirty()) {
                transaction.commit();
            }
        }
        catch (CommitException e) {
            logger.error("Commit failed", (Throwable)e);
        }
        finally {
            transaction.close();
        }
    }

    protected void analyzeProperty(PropertyFileDescriptor descriptor, List<ReviewParticipant> activeReviews, PropertyFile masterProperties, Property prop) {
        this.removeKey(prop.getKey(), (List<Review>)descriptor.getReviews());
        Property masterProp = masterProperties.getProperty(prop.getKey());
        for (ReviewParticipant reviewer : activeReviews) {
            Review review = null;
            review = descriptor.isMaster() ? reviewer.review(descriptor, prop, null) : reviewer.review(descriptor, masterProp, prop);
            if (review == null) continue;
            review.setKey(prop.getKey());
            descriptor.getReviews().add((Object)review);
        }
    }

    private List<ReviewParticipant> getActiveReviews(Project project) {
        ArrayList<ReviewParticipant> activeParticipants = new ArrayList<ReviewParticipant>();
        Preferences node = PreferencesUtil.scopeFor(project).node("checks");
        for (ReviewParticipant participant : this.participants) {
            if (!node.getBoolean(participant.getID(), false)) continue;
            activeParticipants.add(participant);
        }
        return activeParticipants;
    }

    public Collection<Review> review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        List<ReviewParticipant> participants = this.getActiveReviews((Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent());
        for (ReviewParticipant reviewParticipant : participants) {
            Review review = reviewParticipant.review(descriptor, master, slave);
            if (review == null) continue;
            reviews.add(review);
        }
        return reviews;
    }
}

