/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.review.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.review.TerminologyProvider;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service(value={TerminologyProvider.class})
public class TerminologyProviderImpl
extends CacheLoader<Locale, Map<String, Property>>
implements TerminologyProvider,
Supplier<ProjectVersion> {
    private LoadingCache<Locale, Map<String, Property>> terminologyCache;
    private CDONet4jSession session;
    private CDOView view;
    private Supplier<ProjectVersion> version;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private RepositoryConnector repositoryConnector;

    @Activate
    public void activate() {
        this.terminologyCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).concurrencyLevel(2).build((CacheLoader)this);
        this.version = Suppliers.memoize((Supplier)this);
    }

    @Override
    public Map<String, Property> getTerminology(Locale locale) {
        try {
            return (Map)this.terminologyCache.get((Object)locale);
        }
        catch (ExecutionException e) {
            this.logger.error("Failed to retrieve termininology from cache. Skipping check.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public Map<String, Property> load(Locale locale) throws Exception {
        EList descriptors;
        ProjectLocale projectLocale;
        ProjectVersion projectVersion;
        if (this.version.get() == null) {
            this.version = Suppliers.memoize((Supplier)this);
        }
        if ((projectVersion = (ProjectVersion)this.version.get()) != null && (projectLocale = projectVersion.getProjectLocale(locale)) != null && !(descriptors = projectLocale.getDescriptors()).isEmpty()) {
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)descriptors.get(0);
            return descriptor.loadProperties().asMap();
        }
        return Collections.emptyMap();
    }

    public ProjectVersion get() {
        if (this.view == null) {
            return null;
        }
        CDOResource resource = this.view.getResource("workspace");
        Workspace workspace = (Workspace)resource.getContents().get(0);
        return workspace.getTerminology();
    }

    public void bindRepositoryConnector(RepositoryConnector connector) {
        this.session = connector.createSession();
        this.view = this.session.openView();
    }

    public void unbindRepositoryConnector(RepositoryConnector connector) {
        this.view.close();
        this.view = null;
        this.session.close();
        this.session = null;
    }

    @Deactivate
    public void deactivate() {
        if (this.view != null) {
            this.view.close();
        }
        if (this.session != null) {
            this.session.close();
        }
    }
}

