/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.team;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jabylon.common.team.TeamProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamProviderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamProviderUtil.class);

    public static List<String> getAvailableTeamProviders() {
        Bundle bundle = FrameworkUtil.getBundle(TeamProviderUtil.class);
        BundleContext context = bundle.getBundleContext();
        ArrayList<String> providers = new ArrayList<String>();
        try {
            Collection references = context.getServiceReferences(TeamProvider.class, null);
            for (ServiceReference reference : references) {
                Object property = reference.getProperty("kind");
                if (property == null) {
                    LOGGER.error("Team provider service has no 'kind' property. Ignoring team provider from " + reference.getBundle());
                    continue;
                }
                providers.add(property.toString());
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Failed to retrieve service references", (Throwable)e);
        }
        return providers;
    }

    public static TeamProvider getTeamProvider(String name) {
        if (name == null) {
            return null;
        }
        try {
            Bundle bundle = FrameworkUtil.getBundle(TeamProviderUtil.class);
            BundleContext context = bundle.getBundleContext();
            Collection references = context.getServiceReferences(TeamProvider.class, null);
            for (ServiceReference reference : references) {
                Object property = reference.getProperty("kind");
                if (!name.equals(property)) continue;
                return (TeamProvider)context.getService(reference);
            }
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Failed to retrieve service references", (Throwable)e);
        }
        return null;
    }
}

