/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class AttachablePreferences
implements Preferences,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Preferences> children;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Preferences parent;
    private String name;

    public AttachablePreferences() {
        this(null, "attachable");
    }

    public AttachablePreferences(Preferences parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String absolutePath() {
        if (this.parent != null) {
            return this.parent.absolutePath() + "/" + this.name();
        }
        return "/" + this.name();
    }

    public String[] childrenNames() throws BackingStoreException {
        if (this.children == null) {
            return new String[0];
        }
        Set<String> keys = this.children.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void clear() throws BackingStoreException {
        this.values.clear();
    }

    public void flush() throws BackingStoreException {
    }

    public String get(String arg0, String arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            return String.valueOf(this.values.get(arg0));
        }
        return arg1;
    }

    public boolean getBoolean(String arg0, boolean arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            Object value = this.values.get(arg0);
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
            return (Boolean)value;
        }
        return arg1;
    }

    public byte[] getByteArray(String arg0, byte[] arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            return (byte[])this.values.get(arg0);
        }
        return arg1;
    }

    public double getDouble(String arg0, double arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            Object value = this.values.get(arg0);
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            return (Double)value;
        }
        return arg1;
    }

    public float getFloat(String arg0, float arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            Object value = this.values.get(arg0);
            if (value instanceof String) {
                return Float.parseFloat((String)value);
            }
            return ((Float)value).floatValue();
        }
        return arg1;
    }

    public int getInt(String arg0, int arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            Object value = this.values.get(arg0);
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            return (Integer)value;
        }
        return arg1;
    }

    public long getLong(String arg0, long arg1) {
        if (this.values != null && this.values.containsKey(arg0)) {
            Object value = this.values.get(arg0);
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
            return (Long)value;
        }
        return arg1;
    }

    public String[] keys() throws BackingStoreException {
        if (this.values == null) {
            return new String[0];
        }
        Set<String> keys = this.values.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String arg0) {
        Map<String, Preferences> children = this.getOrCreateChildren();
        AttachablePreferences child = (AttachablePreferences)children.get(arg0);
        if (child == null) {
            child = new AttachablePreferences();
            children.put(arg0, child);
        }
        return child;
    }

    private Map<String, Preferences> getOrCreateChildren() {
        if (this.children == null) {
            this.children = new HashMap<String, Preferences>();
        }
        return this.children;
    }

    public boolean nodeExists(String arg0) throws BackingStoreException {
        return this.getOrCreateChildren().containsKey(arg0);
    }

    public Preferences parent() {
        return this.parent;
    }

    public void put(String arg0, String arg1) {
        this.values.put(arg0, arg1);
    }

    public void putBoolean(String arg0, boolean arg1) {
        this.values.put(arg0, arg1);
    }

    public void putByteArray(String arg0, byte[] arg1) {
        this.values.put(arg0, arg1);
    }

    public void putDouble(String arg0, double arg1) {
        this.values.put(arg0, arg1);
    }

    public void putFloat(String arg0, float arg1) {
        this.values.put(arg0, Float.valueOf(arg1));
    }

    public void putInt(String arg0, int arg1) {
        this.values.put(arg0, arg1);
    }

    public void putLong(String arg0, long arg1) {
        this.values.put(arg0, arg1);
    }

    public void remove(String arg0) {
        this.values.remove(arg0);
    }

    public void removeNode() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
    }

    public String toString() {
        return this.absolutePath();
    }
}

