/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DelegatingPreferences
implements Preferences,
Serializable {
    private static final long serialVersionUID = -2100265681534715500L;
    private transient Preferences delegate;
    private String absolutePath;
    private boolean dirty;
    private List<DelegatingPreferences> children;
    private Map<String, Object> values;

    public DelegatingPreferences(Preferences delegate) {
        this.delegate = delegate;
        this.absolutePath = delegate.absolutePath();
        this.children = new ArrayList<DelegatingPreferences>();
        this.values = new HashMap<String, Object>();
    }

    public void put(String key, String value) {
        this.values.put(key, value);
        this.dirty = true;
    }

    public String get(String key, String def) {
        if (this.values.containsKey(key)) {
            return String.valueOf(this.values.get(key));
        }
        return this.getDelegate().get(key, def);
    }

    public void remove(String key) {
        this.values.remove(key);
        this.dirty = true;
    }

    public void clear() throws BackingStoreException {
        this.getDelegate().clear();
        this.dirty = true;
    }

    public void putInt(String key, int value) {
        this.getDelegate().putInt(key, value);
        this.dirty = true;
    }

    public int getInt(String key, int def) {
        if (this.values.containsKey(key)) {
            return (Integer)this.values.get(key);
        }
        return this.getDelegate().getInt(key, def);
    }

    public void putLong(String key, long value) {
        this.getDelegate().putLong(key, value);
        this.dirty = true;
    }

    public long getLong(String key, long def) {
        if (this.values.containsKey(key)) {
            return (Long)this.values.get(key);
        }
        return this.getDelegate().getLong(key, def);
    }

    public void putBoolean(String key, boolean value) {
        this.getDelegate().putBoolean(key, value);
        this.dirty = true;
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.values.containsKey(key)) {
            return (Boolean)this.values.get(key);
        }
        return this.getDelegate().getBoolean(key, def);
    }

    public void putFloat(String key, float value) {
        this.getDelegate().putFloat(key, value);
        this.dirty = true;
    }

    public float getFloat(String key, float def) {
        if (this.values.containsKey(key)) {
            return ((Float)this.values.get(key)).floatValue();
        }
        return this.getDelegate().getFloat(key, def);
    }

    public void putDouble(String key, double value) {
        this.getDelegate().putDouble(key, value);
        this.dirty = true;
    }

    public double getDouble(String key, double def) {
        if (this.values.containsKey(key)) {
            return (Double)this.values.get(key);
        }
        return this.getDelegate().getDouble(key, def);
    }

    public void putByteArray(String key, byte[] value) {
        this.getDelegate().putByteArray(key, value);
        this.dirty = true;
    }

    public byte[] getByteArray(String key, byte[] def) {
        if (this.values.containsKey(key)) {
            return (byte[])this.values.get(key);
        }
        return this.getDelegate().getByteArray(key, def);
    }

    public String[] keys() throws BackingStoreException {
        HashSet<String> keys = new HashSet<String>(this.values.keySet());
        keys.addAll(Arrays.asList(this.getDelegate().keys()));
        return keys.toArray(new String[keys.size()]);
    }

    public String[] childrenNames() throws BackingStoreException {
        return this.getDelegate().childrenNames();
    }

    public Preferences parent() {
        return this.getDelegate().parent();
    }

    public Preferences node(String pathName) {
        try {
            if (!this.nodeExists(pathName)) {
                this.dirty = true;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        DelegatingPreferences child = new DelegatingPreferences(this.getDelegate().node(pathName));
        this.children.add(child);
        return child;
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.getDelegate().nodeExists(pathName);
    }

    public void removeNode() throws BackingStoreException {
        this.dirty = true;
        this.getDelegate().removeNode();
    }

    public String name() {
        return this.getDelegate().name();
    }

    public String absolutePath() {
        return this.getDelegate().absolutePath();
    }

    public void flush() throws BackingStoreException {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        for (DelegatingPreferences child : this.children) {
            child.flush();
        }
        this.getDelegate().flush();
        this.dirty = false;
    }

    public void sync() throws BackingStoreException {
        this.getDelegate().sync();
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        for (DelegatingPreferences child : this.children) {
            if (!child.isDirty()) continue;
            return true;
        }
        return false;
    }

    protected void setValue(String key, Object value) {
        if (value instanceof String) {
            this.getDelegate().put(key, (String)value);
        } else if (value instanceof Boolean) {
            this.getDelegate().putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof byte[]) {
            this.getDelegate().putByteArray(key, (byte[])value);
        } else if (value instanceof Double) {
            this.getDelegate().putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.getDelegate().putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.getDelegate().putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.getDelegate().putLong(key, ((Long)value).longValue());
        } else if (value == null) {
            this.getDelegate().remove(key);
        } else {
            throw new IllegalArgumentException("Object type " + value + " not supported");
        }
    }

    private Preferences getDelegate() {
        if (this.delegate == null) {
            this.delegate = InstanceScope.INSTANCE.getNode(this.absolutePath);
        }
        return this.delegate;
    }
}

