/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.util;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;

public class IConfigurationElementLoader
implements Function<String, List<IConfigurationElement>> {
    public List<IConfigurationElement> apply(String extensionPoint) {
        IConfigurationElement[] elements;
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        for (IConfigurationElement iConfigurationElement : elements = RegistryFactory.getRegistry().getConfigurationElementsFor(extensionPoint)) {
            result.add(iConfigurationElement);
        }
        Collections.sort(result, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String precedence2;
                String precedence1 = o1.getAttribute("precedence");
                if (precedence1 == null) {
                    precedence1 = "999999";
                }
                if ((precedence2 = o2.getAttribute("precedence")) == null) {
                    precedence2 = "999999";
                }
                return Integer.parseInt(precedence1) - Integer.parseInt(precedence2);
            }
        });
        return result;
    }
}

