/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.util;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.ScanConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesUtil.class);
    public static final String SCAN_CONFIG_INCLUDE = "include";
    public static final String SCAN_CONFIG_EXCLUDE = "exclude";
    public static final String SCAN_CONFIG_MASTER_LOCALE = "master.locale";
    public static final String NODE_CHECKS = "checks";
    public static final Supplier<URIResolver> resolver = Suppliers.memoize((Supplier)Suppliers.compose((Function)new Function<BundleContext, URIResolver>(){

        public URIResolver apply(BundleContext input) {
            ServiceReference reference = input.getServiceReference(URIResolver.class);
            if (reference != null) {
                return (URIResolver)input.getService(reference);
            }
            return null;
        }
    }, (Supplier)Suppliers.ofInstance((Object)FrameworkUtil.getBundle(PreferencesUtil.class).getBundleContext())));
    private static boolean isMigrated = false;

    private PreferencesUtil() {
    }

    public static Preferences scopeFor(Object eobject) {
        PreferencesUtil.migrate();
        URI uri = ((URIResolver)resolver.get()).getURI(eobject);
        String path = uri.toString();
        IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode("org.jabylon.common/config");
        return rootNode.node(path);
    }

    public static URI toLookupURI(Preferences prefs) {
        String absolutePath = prefs.absolutePath();
        absolutePath = absolutePath.substring("org.jabylon.common/config".length());
        return URI.createURI((String)absolutePath);
    }

    private static void migrate() {
        if (isMigrated) {
            return;
        }
        IEclipsePreferences oldNode = InstanceScope.INSTANCE.getNode("de.jutzig.jabylon.common");
        try {
            String[] childrenNames;
            if (oldNode.nodeExists("config")) {
                LOGGER.info("Migrating old Preferences");
                IEclipsePreferences newNode = InstanceScope.INSTANCE.getNode("org.jabylon.common");
                PreferencesUtil.cloneNode((Preferences)oldNode, (Preferences)newNode);
                PreferencesUtil.deleteNode(oldNode.node("config"));
            }
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.jabylon.common/config");
            for (String child : childrenNames = node.childrenNames()) {
                if (child.equals("workspace") || child.equals("security")) continue;
                LOGGER.info("Migrating {} to {}", (Object)child, (Object)("workspace/" + child));
                Preferences old = node.node(child);
                PreferencesUtil.cloneNode(old, node.node("workspace/" + child));
                PreferencesUtil.deleteNode(old);
            }
            isMigrated = true;
        }
        catch (BackingStoreException e) {
            LOGGER.error("Failed to check if old config needs to be migrated");
        }
    }

    public static void cloneNode(Preferences source, Preferences target) throws BackingStoreException {
        PreferencesUtil.shallowClonePreferences(source, target);
        PreferencesUtil.copyChildPreferences(source, target);
        target.sync();
    }

    public static Preferences workspaceScope() {
        return InstanceScope.INSTANCE.getNode("org.jabylon.common/config/workspace");
    }

    public static Preferences rootScope() {
        return InstanceScope.INSTANCE.getNode("org.jabylon.common");
    }

    public static void deleteNode(Preferences node) throws BackingStoreException {
        Preferences parent = null;
        try {
            parent = node.parent();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to retrieve parent node", (Throwable)e);
        }
        node.removeNode();
        if (parent != null) {
            parent.flush();
        }
    }

    public static Preferences renamePreferenceNode(Preferences node, String newName) {
        Preferences parent = node.parent();
        Preferences clone = parent.node(newName);
        try {
            PreferencesUtil.copyChildPreferences(node, clone);
            PreferencesUtil.deleteNode(parent);
        }
        catch (BackingStoreException e) {
            LOGGER.error("Failed to rename preferences from " + node + " to " + clone, (Throwable)e);
        }
        return clone;
    }

    protected static void shallowClonePreferences(Preferences node, Preferences clone) {
        try {
            for (String key : node.keys()) {
                String value = node.get(key, "");
                clone.put(key, value);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.error("Failed to clone preferences from " + node + " to " + clone, (Throwable)e);
        }
    }

    public static void copyChildPreferences(Preferences oldParent, Preferences newParent) throws BackingStoreException {
        for (String name : oldParent.childrenNames()) {
            Preferences child = oldParent.node(name);
            Preferences copy = newParent.node(name);
            PreferencesUtil.shallowClonePreferences(child, copy);
            PreferencesUtil.copyChildPreferences(child, copy);
        }
    }

    public static final ScanConfiguration getScanConfigForProject(Project project) {
        Preferences node = PreferencesUtil.scopeFor(project);
        ScanConfiguration configuration = PropertiesFactory.eINSTANCE.createScanConfiguration();
        configuration.setExclude(node.get(SCAN_CONFIG_EXCLUDE, PropertiesPackage.Literals.SCAN_CONFIGURATION__EXCLUDE.getDefaultValueLiteral()));
        configuration.setInclude(node.get(SCAN_CONFIG_INCLUDE, PropertiesPackage.Literals.SCAN_CONFIGURATION__INCLUDE.getDefaultValueLiteral()));
        configuration.setMasterLocale(node.get(SCAN_CONFIG_MASTER_LOCALE, PropertiesPackage.Literals.SCAN_CONFIGURATION__MASTER_LOCALE.getDefaultValueLiteral()));
        return configuration;
    }

    public static Preferences getNodeForJob(Preferences context, String jobID) {
        return context.node("jobs").node(jobID);
    }
}

