/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.common.util.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.jabylon.common.util.IConfigurationElementLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigUtil {
    private static Supplier<List<IConfigurationElement>> configSections;
    private static Supplier<List<IConfigurationElement>> configTabs;
    private static final Logger LOG;

    private static synchronized void createSuppliers() {
        configTabs = Suppliers.memoize((Supplier)Suppliers.compose((Function)new IConfigurationElementLoader(), (Supplier)Suppliers.ofInstance((Object)"org.jabylon.rest.ui.configTab")));
        configSections = Suppliers.memoize((Supplier)Suppliers.compose((Function)new IConfigurationElementLoader(), (Supplier)Suppliers.ofInstance((Object)"org.jabylon.rest.ui.config")));
    }

    public static void refresh() {
        LOG.info("Refreshing config contributions");
        DynamicConfigUtil.createSuppliers();
    }

    private DynamicConfigUtil() {
    }

    public static List<IConfigurationElement> getApplicableElements(Object domainObject) {
        List<IConfigurationElement> configSections = DynamicConfigUtil.getConfigSections();
        try {
            ArrayList<IConfigurationElement> applicable = new ArrayList<IConfigurationElement>();
            for (IConfigurationElement child : configSections) {
                if (!DynamicConfigUtil.isApplicable(child, domainObject)) continue;
                applicable.add(child);
            }
            return applicable;
        }
        catch (InvalidRegistryObjectException e) {
            LOG.warn("Failed to retrieve config extensions. Reloading", (Throwable)e);
            DynamicConfigUtil.createSuppliers();
            List<IConfigurationElement> applicableElements = DynamicConfigUtil.getApplicableElements(domainObject);
            LOG.warn("Reload complete", (Throwable)e);
            return applicableElements;
        }
    }

    private static boolean isApplicable(IConfigurationElement child, Object domainElement) {
        String objectClass = child.getAttribute("objectClass");
        try {
            Class<?> clazz = Class.forName(objectClass);
            return clazz.isInstance(domainElement);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<IConfigurationElement> getConfigSections() {
        return (List)configSections.get();
    }

    public static List<IConfigurationElement> getConfigTabs() {
        return (List)configTabs.get();
    }

    static {
        LOG = LoggerFactory.getLogger(DynamicConfigUtil.class);
        DynamicConfigUtil.createSuppliers();
    }
}

