/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.updatecenter.repository;

public enum BundleState {
    INSTALLED(2, "important"),
    RESOLVED(4, "warning"),
    STARTING(8, "info"),
    ACTIVE(32, "success"),
    UNINSTALLED(1, "inverse");

    private int state;
    private String labelClass;

    private BundleState(int state, String labelClass) {
        this.state = state;
        this.labelClass = labelClass;
    }

    public static BundleState fromState(int state) {
        for (BundleState bundleState : BundleState.values()) {
            if (bundleState.state != state) continue;
            return bundleState;
        }
        return null;
    }

    public String getLabelClass() {
        return this.labelClass;
    }
}

