/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.updatecenter.repository.ui;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.jabylon.rest.ui.model.ComputableModel;
import org.jabylon.rest.ui.security.RestrictedComponent;
import org.jabylon.rest.ui.util.GlobalResources;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.updatecenter.repository.BundleState;
import org.jabylon.updatecenter.repository.OBRRepositoryService;
import org.jabylon.updatecenter.repository.ui.ComputeBundleLabelClass;
import org.jabylon.updatecenter.repository.ui.ComputeStateFunction;
import org.jabylon.updatecenter.repository.ui.LoadBundlesFunction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstalledSoftwareTab
extends BasicPanel<String>
implements RestrictedComponent {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<BundleState> STOPPABLE_STATE = EnumSet.of(BundleState.ACTIVE, BundleState.STARTING);
    private static final EnumSet<BundleState> STARTABLE_STATE = EnumSet.of(BundleState.RESOLVED);
    private static final EnumSet<BundleState> CHANGEABLE_STATE;
    @Inject
    private OBRRepositoryService repositoryConnector;
    private static final Logger logger;

    public InstalledSoftwareTab(String id) {
        super(id, (IModel)Model.of((Serializable)((Object)"")), new PageParameters());
        StatelessForm form = new StatelessForm("form");
        this.add(new Component[]{form});
        ComputableModel model = new ComputableModel((Function)new LoadBundlesFunction(), null);
        ListView<Bundle> resourceView = new ListView<Bundle>("row", (IModel)model, (Form)form){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ Form val$form;
            {
                this.val$form = form;
                super(x0, x1);
            }

            protected void populateItem(final ListItem<Bundle> item) {
                item.setOutputMarkupId(true);
                Bundle resource = (Bundle)item.getModelObject();
                final long bundleId = resource.getBundleId();
                String name = resource.getSymbolicName();
                item.add(new Component[]{new Label("name", name)});
                item.add(new Component[]{new Label("version", resource.getVersion().toString())});
                int state = resource.getState();
                BundleState bundleState = BundleState.fromState(state);
                ComputableModel labelClassModel = new ComputableModel((Function)new ComputeBundleLabelClass(), (Object)bundleId);
                ComputableModel labelNameModel = new ComputableModel((Function)new ComputeStateFunction(), (Object)bundleId);
                Label stateLabel = new Label("state", (IModel)labelNameModel);
                stateLabel.add(new Behavior[]{new AttributeAppender("class", (IModel)labelClassModel)});
                item.add(new Component[]{stateLabel});
                String action = bundleState == BundleState.RESOLVED ? "start" : "stop";
                AjaxFallbackButton button = new AjaxFallbackButton("action", (IModel)Model.of((Serializable)((Object)action)), this.val$form){
                    private static final long serialVersionUID = 1L;

                    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        if (target != null) {
                            target.add(new Component[]{this});
                            target.add(new Component[]{item});
                        }
                        BundleContext context = FrameworkUtil.getBundle(InstalledSoftwareTab.class).getBundleContext();
                        Bundle bundle = context.getBundle(bundleId);
                        BundleState state = BundleState.fromState(bundle.getState());
                        if (STARTABLE_STATE.contains((Object)state)) {
                            logger.info("Starting bundle {}", (Object)bundle.getSymbolicName());
                            try {
                                bundle.start();
                            }
                            catch (BundleException e) {
                                String message = "Failed to start bundle " + bundle.getSymbolicName();
                                this.getSession().error((Serializable)((Object)message));
                                logger.error(message, (Throwable)e);
                            }
                        } else if (STOPPABLE_STATE.contains((Object)state)) {
                            logger.info("Stoping bundle {}", (Object)bundle.getSymbolicName());
                            try {
                                bundle.stop();
                            }
                            catch (BundleException e) {
                                String message = "Failed to stop bundle " + bundle.getSymbolicName();
                                this.getSession().error((Serializable)((Object)message));
                                logger.error(message, (Throwable)e);
                            }
                        }
                        super.onSubmit(target, form);
                    }
                };
                button.setDefaultFormProcessing(false);
                button.add(new Behavior[]{new AttributeModifier("value", (Serializable)Long.valueOf(resource.getBundleId()))});
                button.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"btn btn-small"))});
                button.setEnabled(CHANGEABLE_STATE.contains((Object)bundleState));
                item.add(new Component[]{button});
            }
        };
        form.add(new Component[]{resourceView});
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_JQUERY_DATATABLES));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)GlobalResources.JS_BOOTSTRAP_DATATABLES));
        super.renderHead(response);
    }

    public String getRequiredPermission() {
        return "System:software:config";
    }

    static {
        EnumSet<BundleState> set = EnumSet.copyOf(STOPPABLE_STATE);
        set.addAll(STARTABLE_STATE);
        CHANGEABLE_STATE = set;
        logger = LoggerFactory.getLogger(InstalledSoftwareTab.class);
    }
}

