/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.internal;

import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.common.review.TerminologyProvider;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.Severity;

@Component
@Service
public class EqualityCheck
implements ReviewParticipant {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private TerminologyProvider terminologyProvider;

    public Review review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        if (master == null || slave == null) {
            return null;
        }
        String masterValue = master.getValue();
        String slaveValue = slave.getValue();
        if (masterValue != null && masterValue.equals(slaveValue)) {
            Map terminology;
            Property terminologyEntry;
            if (this.terminologyProvider != null && (terminologyEntry = (Property)(terminology = this.terminologyProvider.getTerminology(descriptor.getVariant())).get(slave.getValue())) != null && slave.getValue().equals(terminologyEntry.getValue())) {
                return null;
            }
            Review review = PropertiesFactory.eINSTANCE.createReview();
            review.setCreated(System.currentTimeMillis());
            review.setMessage("Template and translated string are identical");
            review.setReviewType("Equality Check");
            review.setSeverity(Severity.WARNING);
            review.setUser("Jabylon");
            return review;
        }
        return null;
    }

    public void bindTerminologyProvider(TerminologyProvider provider) {
        this.terminologyProvider = provider;
    }

    public void unbindTerminologyProvider(TerminologyProvider provider) {
        if (this.terminologyProvider == provider) {
            this.terminologyProvider = null;
        }
    }

    public String getID() {
        return "EqualityCheck";
    }

    public String getDescription() {
        return "%equality.check.description";
    }

    public String getName() {
        return "%equality.check.name";
    }
}

