/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.internal;

import java.text.MessageFormat;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.Severity;

@Component
@Service
public class ExistenceCheck
implements ReviewParticipant {
    public Review review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        boolean masterExists = this.exists(master);
        if (masterExists) {
            return null;
        }
        if (master != null && !this.exists(slave)) {
            return null;
        }
        if (slave != null) {
            Review review = PropertiesFactory.eINSTANCE.createReview();
            review.setCreated(System.currentTimeMillis());
            String message = "The key ''{0}'' is missing in the template language";
            message = MessageFormat.format(message, slave.getKey());
            review.setMessage(message);
            review.setUser("Jabylon");
            review.setReviewType("Missing Key");
            review.setSeverity(Severity.ERROR);
            return review;
        }
        return null;
    }

    private boolean exists(Property property) {
        if (property == null) {
            return false;
        }
        if (property.getValue() == null) {
            return false;
        }
        return property.getValue().trim().length() != 0;
    }

    public String getID() {
        return "ExistenceCheck";
    }

    public String getDescription() {
        return "%existance.check.description";
    }

    public String getName() {
        return "%existance.check.name";
    }
}

