/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.review.standard.internal;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.jabylon.common.review.ReviewParticipant;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Review;
import org.jabylon.properties.Severity;

@Component
@Service
public class MessageFormatCheck
implements ReviewParticipant {
    private static final Pattern PATTERN = Pattern.compile("\\{(\\d+)(,.*?)?\\}");

    public Review review(PropertyFileDescriptor descriptor, Property master, Property slave) {
        if (master == null || slave == null || master.getValue() == null || slave.getValue() == null) {
            return null;
        }
        Matcher masterMatcher = PATTERN.matcher(master.getValue());
        HashSet<String> masterPatterns = new HashSet<String>();
        while (masterMatcher.find()) {
            masterPatterns.add("{" + masterMatcher.group(1) + "}");
        }
        HashSet mustHavePatterns = new HashSet(masterPatterns);
        Matcher slaveMatcher = PATTERN.matcher(slave.getValue());
        while (slaveMatcher.find()) {
            String patternNumber = slaveMatcher.group(1);
            String pattern = "{" + patternNumber + "}";
            if (!masterPatterns.contains(pattern)) {
                Review review = PropertiesFactory.eINSTANCE.createReview();
                review.setCreated(System.currentTimeMillis());
                String message = "Translation contains message format ''{0}'' which is not present in the template language";
                review.setMessage(MessageFormat.format(message, pattern));
                review.setUser("Jabylon");
                review.setReviewType("Message Format");
                review.setSeverity(Severity.ERROR);
                return review;
            }
            mustHavePatterns.remove(pattern);
        }
        if (!mustHavePatterns.isEmpty()) {
            Review review = PropertiesFactory.eINSTANCE.createReview();
            String message = "The template language contains message format ''{0}'' which is not referenced in the translation";
            review.setMessage(MessageFormat.format(message, mustHavePatterns.iterator().next()));
            review.setUser("Jabylon");
            review.setSeverity(Severity.ERROR);
            review.setReviewType("Message Format");
            return review;
        }
        return null;
    }

    public String getID() {
        return "MessageFormatCheck";
    }

    public String getDescription() {
        return "%messageformat.check.description";
    }

    public String getName() {
        return "%messageformat.check.name";
    }
}

