/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.cdo.connector;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.transaction.TransactionException;
import org.jabylon.cdo.connector.Modification;

public class TransactionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends EObject, R extends EObject> R commit(T parent, Modification<T, R> op) throws CommitException {
        if (parent instanceof CDOObject) {
            CDOObject cdoObject = (CDOObject)parent;
            CDOView view = cdoObject.cdoView();
            CDOTransaction transaction = TransactionUtil.getTransaction(cdoObject);
            EObject writableObject = transaction.getObject(parent);
            EObject returnValue = null;
            try {
                returnValue = (EObject)op.apply(writableObject);
                transaction.commit();
                EObject eObject = returnValue;
                return (R)eObject;
            }
            finally {
                if (view != transaction) {
                    transaction.close();
                    if (returnValue != null) {
                        return (R)view.getObject(returnValue);
                    }
                }
            }
        }
        throw new TransactionException("could not obtain a transaction");
    }

    public static void deleteWithCrossRefs(CDOObject object, final EReference ... features) throws CommitException {
        TransactionUtil.commit(object, new Modification<CDOObject, CDOObject>(){

            @Override
            public CDOObject apply(CDOObject object) {
                List refs = object.cdoView().queryXRefs(object, features);
                for (CDOObjectReference reference : refs) {
                    EStructuralFeature sourceFeature = reference.getSourceFeature();
                    if (sourceFeature.isMany()) {
                        Object result = ((CDOObject)reference.getSourceObject()).eGet(sourceFeature);
                        if (!(result instanceof Collection)) continue;
                        Collection collection = (Collection)result;
                        collection.remove(object);
                        continue;
                    }
                    ((CDOObject)reference.getSourceObject()).eUnset(sourceFeature);
                }
                EcoreUtil.remove((EObject)object);
                return null;
            }
        });
    }

    private static CDOTransaction getTransaction(CDOObject object) {
        CDOView view = object.cdoView();
        if (view instanceof CDOTransaction) {
            CDOTransaction transaction = (CDOTransaction)view;
            return transaction;
        }
        if (view != null) {
            return view.getSession().openTransaction();
        }
        throw new TransactionException("could not obtain a transaction");
    }
}

