/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.cdo.connector.internal;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.users.UsersPackage;

@Component
@Service(value={RepositoryConnector.class})
public class RepositoryConnectorImpl
implements RepositoryConnector {
    private IConnector connector = null;
    private CDONet4jSession session = null;
    @Reference
    private IAcceptor acceptor;
    private static final String REPOSITORY_NAME = "jabylon";

    @Override
    @Deactivate
    public void close() {
        if (this.session != null) {
            LifecycleUtil.deactivate((Object)this.session);
        }
        if (this.connector != null) {
            LifecycleUtil.deactivate((Object)this.connector);
        }
    }

    public void bindAcceptor(IAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void unbindAcceptor(IAcceptor acceptor) {
        this.acceptor = null;
    }

    public CDONet4jSession getSession() {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    @Override
    public CDOTransaction openTransaction() {
        return this.getSession().openTransaction();
    }

    @Override
    public CDOView openView() {
        return this.getSession().openView();
    }

    @Override
    public CDONet4jSession createSession() {
        IPluginContainer container = IPluginContainer.INSTANCE;
        if (this.connector == null) {
            this.connector = JVMUtil.getConnector((IManagedContainer)container, (String)"default");
        }
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(REPOSITORY_NAME);
        CDONet4jSession theSession = config.openNet4jSession();
        theSession.options().setCollectionLoadingPolicy(CDOUtil.createCollectionLoadingPolicy((int)-1, (int)-1));
        theSession.getPackageRegistry().putEPackage((EPackage)PropertiesPackage.eINSTANCE);
        theSession.getPackageRegistry().putEPackage((EPackage)UsersPackage.eINSTANCE);
        return theSession;
    }
}

