/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.users.impl;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UsersPackage;

public class UserImpl
extends CDOObjectImpl
implements User {
    protected static final String NAME_EDEFAULT = null;
    protected static final String PASSWORD_EDEFAULT = null;
    protected static final String DISPLAY_NAME_EDEFAULT = null;
    protected static final String TYPE_EDEFAULT = null;
    protected static final String EMAIL_EDEFAULT = null;
    protected static final String TOKEN_EDEFAULT = null;

    protected UserImpl() {
    }

    protected EClass eStaticClass() {
        return UsersPackage.Literals.USER;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public String getName() {
        return (String)this.eDynamicGet(0, (EStructuralFeature)UsersPackage.Literals.USER__NAME, true, true);
    }

    @Override
    public void setName(String newName) {
        this.eDynamicSet(0, (EStructuralFeature)UsersPackage.Literals.USER__NAME, newName);
    }

    @Override
    public String getPassword() {
        return (String)this.eDynamicGet(1, (EStructuralFeature)UsersPackage.Literals.USER__PASSWORD, true, true);
    }

    @Override
    public void setPassword(String newPassword) {
        this.eDynamicSet(1, (EStructuralFeature)UsersPackage.Literals.USER__PASSWORD, newPassword);
    }

    @Override
    public EList<Role> getRoles() {
        return (EList)this.eDynamicGet(2, (EStructuralFeature)UsersPackage.Literals.USER__ROLES, true, true);
    }

    @Override
    public EList<Permission> getPermissions() {
        return (EList)this.eDynamicGet(3, (EStructuralFeature)UsersPackage.Literals.USER__PERMISSIONS, true, true);
    }

    @Override
    public String getDisplayName() {
        return (String)this.eDynamicGet(4, (EStructuralFeature)UsersPackage.Literals.USER__DISPLAY_NAME, true, true);
    }

    @Override
    public void setDisplayName(String newDisplayName) {
        this.eDynamicSet(4, (EStructuralFeature)UsersPackage.Literals.USER__DISPLAY_NAME, newDisplayName);
    }

    @Override
    public String getType() {
        return (String)this.eDynamicGet(5, (EStructuralFeature)UsersPackage.Literals.USER__TYPE, true, true);
    }

    @Override
    public void setType(String newType) {
        this.eDynamicSet(5, (EStructuralFeature)UsersPackage.Literals.USER__TYPE, newType);
    }

    @Override
    public String getEmail() {
        return (String)this.eDynamicGet(6, (EStructuralFeature)UsersPackage.Literals.USER__EMAIL, true, true);
    }

    @Override
    public void setEmail(String newEmail) {
        this.eDynamicSet(6, (EStructuralFeature)UsersPackage.Literals.USER__EMAIL, newEmail);
    }

    @Override
    public String getToken() {
        return (String)this.eDynamicGet(7, (EStructuralFeature)UsersPackage.Literals.USER__TOKEN, true, true);
    }

    @Override
    public void setToken(String newToken) {
        this.eDynamicSet(7, (EStructuralFeature)UsersPackage.Literals.USER__TOKEN, newToken);
    }

    @Override
    public EList<Permission> getAllPermissions() {
        BasicEList allPermissions = new BasicEList(this.getPermissions());
        for (Role role : this.getRoles()) {
            allPermissions.addAll(role.getAllPermissions());
        }
        return allPermissions;
    }

    @Override
    public boolean hasPermission(String requestedPermission) {
        EList<Permission> allPermissions = this.getAllPermissions();
        for (Permission availablePermission : allPermissions) {
            if (!this.matches(availablePermission, requestedPermission)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Permission availablePermission, String requestedPermission) {
        if (availablePermission.getName() == null || availablePermission.getName().isEmpty()) {
            return false;
        }
        String permissionRegex = availablePermission.getName().replace("*", ".*");
        permissionRegex = permissionRegex + ".*";
        return Pattern.matches(permissionRegex, requestedPermission);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getPassword();
            }
            case 2: {
                return this.getRoles();
            }
            case 3: {
                return this.getPermissions();
            }
            case 4: {
                return this.getDisplayName();
            }
            case 5: {
                return this.getType();
            }
            case 6: {
                return this.getEmail();
            }
            case 7: {
                return this.getToken();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setPassword((String)newValue);
                return;
            }
            case 2: {
                this.getRoles().clear();
                this.getRoles().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getPermissions().clear();
                this.getPermissions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setDisplayName((String)newValue);
                return;
            }
            case 5: {
                this.setType((String)newValue);
                return;
            }
            case 6: {
                this.setEmail((String)newValue);
                return;
            }
            case 7: {
                this.setToken((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 2: {
                this.getRoles().clear();
                return;
            }
            case 3: {
                this.getPermissions().clear();
                return;
            }
            case 4: {
                this.setDisplayName(DISPLAY_NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 6: {
                this.setEmail(EMAIL_EDEFAULT);
                return;
            }
            case 7: {
                this.setToken(TOKEN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 1: {
                return PASSWORD_EDEFAULT == null ? this.getPassword() != null : !PASSWORD_EDEFAULT.equals(this.getPassword());
            }
            case 2: {
                return !this.getRoles().isEmpty();
            }
            case 3: {
                return !this.getPermissions().isEmpty();
            }
            case 4: {
                return DISPLAY_NAME_EDEFAULT == null ? this.getDisplayName() != null : !DISPLAY_NAME_EDEFAULT.equals(this.getDisplayName());
            }
            case 5: {
                return TYPE_EDEFAULT == null ? this.getType() != null : !TYPE_EDEFAULT.equals(this.getType());
            }
            case 6: {
                return EMAIL_EDEFAULT == null ? this.getEmail() != null : !EMAIL_EDEFAULT.equals(this.getEmail());
            }
            case 7: {
                return TOKEN_EDEFAULT == null ? this.getToken() != null : !TOKEN_EDEFAULT.equals(this.getToken());
            }
        }
        return super.eIsSet(featureID);
    }
}

