/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.ui;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Duration;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;
import org.jabylon.rest.ui.model.ComputableModel;
import org.jabylon.rest.ui.model.ProgressionModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ProgressPanel;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.scheduler.JobInstance;
import org.jabylon.scheduler.ScheduleServiceException;
import org.jabylon.scheduler.SchedulerService;
import org.jabylon.scheduler.ui.SizeFunction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.Preferences;

public class JobOverviewPanel
extends BasicPanel<Workspace> {
    private static final long serialVersionUID = -3170612366896934075L;
    private IModel<List<JobInstance>> jobsModel;

    public JobOverviewPanel(String id, IModel<Workspace> model) {
        super(id, model);
    }

    protected void construct() {
        super.construct();
        this.jobsModel = this.createJobsModel();
        WebMarkupContainer container = new WebMarkupContainer("container", this.jobsModel);
        ComputableModel sizeModel = new ComputableModel((Function)new SizeFunction(), this.jobsModel);
        Label noJobs = new Label("running-jobs", (IModel)this.nls("running.jobs.title", new Object[]{sizeModel}));
        noJobs.setOutputMarkupId(true);
        container.add(new Component[]{noJobs});
        ListView<JobInstance> list = new ListView<JobInstance>("list", this.jobsModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<JobInstance> item) {
                JobInstance instance = (JobInstance)item.getModelObject();
                String argLab = this.getLabel(instance.getDomainObject());
                if (argLab == null) {
                    item.add(new Component[]{new Label("title", (IModel)JobOverviewPanel.this.nls(instance.getExecutionObject().getClass(), instance.getDescription(), new Object[0]))});
                } else {
                    item.add(new Component[]{new Label("title", (IModel)JobOverviewPanel.this.nls(instance.getExecutionObject().getClass(), instance.getDescription(), new Object[]{argLab}))});
                }
                ProgressionModel model = new ProgressionModel(instance.getID());
                ProgressPanel progressPanel = new ProgressPanel("panel", model);
                item.add(new Component[]{progressPanel});
                item.setOutputMarkupId(true);
                progressPanel.start();
            }

            private String getLabel(Object domainObject) {
                if (domainObject instanceof Workspace) {
                    return "Workspace";
                }
                if (domainObject instanceof Resolvable) {
                    Resolvable r = (Resolvable)domainObject;
                    return r.fullPath().toString();
                }
                return null;
            }
        };
        list.setOutputMarkupId(true);
        list.setReuseItems(true);
        container.add(new Component[]{list});
        container.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)1))});
        this.add(new Component[]{container});
    }

    private IModel<List<JobInstance>> createJobsModel() {
        return new ComputableModel((Function)new LookupFuncton(), (Object)"");
    }

    protected void detachModel() {
        super.detachModel();
        this.jobsModel.detach();
    }

    public static class JobOverviewConfigSection
    extends AbstractConfigSection<Workspace> {
        private static final long serialVersionUID = 1L;

        public WebMarkupContainer doCreateContents(String id, IModel<Workspace> input, Preferences config) {
            return new JobOverviewPanel(id, input);
        }

        public void commit(IModel<Workspace> input, Preferences config) {
        }

        public String getRequiredPermission() {
            return "Workspace:config";
        }
    }

    private static class LookupFuncton
    implements Function<String, List<JobInstance>>,
    Serializable {
        private static final long serialVersionUID = 1409367843199408286L;

        private LookupFuncton() {
        }

        public List<JobInstance> apply(String input) {
            try {
                BundleContext context = FrameworkUtil.getBundle(JobOverviewPanel.class).getBundleContext();
                ServiceReference reference = context.getServiceReference(SchedulerService.class);
                SchedulerService schedulerService = (SchedulerService)context.getService(reference);
                List runningJobs = schedulerService.getRunningJobs();
                context.ungetService(reference);
                return runningJobs;
            }
            catch (ScheduleServiceException e) {
                return Collections.emptyList();
            }
        }
    }
}

