/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.scheduler.ui;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.rest.ui.model.AttachableModel;
import org.jabylon.rest.ui.model.BooleanPreferencesPropertyModel;
import org.jabylon.rest.ui.model.PreferencesPropertyModel;
import org.jabylon.rest.ui.wicket.BasicPanel;
import org.jabylon.rest.ui.wicket.components.ControlGroup;
import org.jabylon.rest.ui.wicket.config.AbstractConfigSection;
import org.jabylon.rest.ui.wicket.validators.CronValidator;
import org.jabylon.scheduler.ScheduleServiceException;
import org.jabylon.scheduler.SchedulerService;
import org.jabylon.security.CommonPermissions;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamSyncJobConfigPanel
extends BasicPanel<ProjectVersion> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TeamSyncJobConfigPanel.class);
    @Inject
    private SchedulerService scheduler;
    private Preferences root;

    public TeamSyncJobConfigPanel(String id, IModel<ProjectVersion> model, Preferences root) {
        super(id, model);
        this.root = root;
    }

    protected void construct() {
        super.construct();
        Preferences updateConfig = PreferencesUtil.getNodeForJob((Preferences)this.root, (String)"job.team.update");
        PreferencesPropertyModel updateModel = new PreferencesPropertyModel(updateConfig, "schedule", "0 0 * * * ?");
        ControlGroup updateCronGroup = new ControlGroup("update-cron-group", (IModel)this.nls("update.cron.label", new Object[0]), (IModel)this.nls("update.cron.description", new Object[0]));
        TextField updateCron = new TextField("update-cron", (IModel)updateModel);
        updateCron.add((IValidator)new CronValidator());
        updateCron.setConvertEmptyInputStringToNull(true);
        updateCronGroup.add(new Component[]{updateCron});
        this.add(new Component[]{updateCronGroup});
        BooleanPreferencesPropertyModel updateEnabledModel = new BooleanPreferencesPropertyModel(updateConfig, "active", false);
        ControlGroup updateEnabledCronGroup = new ControlGroup("update-cron-enabled-group", (IModel)Model.of((Serializable)((Object)"")), (IModel)this.nls("update.cron.enabled.description", new Object[0]));
        CheckBox updateEnabledCron = new CheckBox("update-cron-enabled", (IModel)updateEnabledModel);
        updateEnabledCronGroup.add(new Component[]{updateEnabledCron});
        this.add(new Component[]{updateEnabledCronGroup});
        Preferences commitConfig = PreferencesUtil.getNodeForJob((Preferences)this.root, (String)"job.team.commit");
        PreferencesPropertyModel commitModel = new PreferencesPropertyModel(commitConfig, "schedule", "0 5 * * * ?");
        ControlGroup commitCronGroup = new ControlGroup("commit-cron-group", (IModel)this.nls("commit.cron.label", new Object[0]), (IModel)this.nls("commit.cron.description", new Object[0]));
        TextField commitCron = new TextField("commit-cron", (IModel)commitModel);
        commitCron.setConvertEmptyInputStringToNull(true);
        commitCron.add((IValidator)new CronValidator());
        commitCronGroup.add(new Component[]{commitCron});
        this.add(new Component[]{commitCronGroup});
        BooleanPreferencesPropertyModel commitEnabledModel = new BooleanPreferencesPropertyModel(commitConfig, "active", false);
        ControlGroup commitEnabledCronGroup = new ControlGroup("commit-cron-enabled-group", (IModel)Model.of((Serializable)((Object)"")), (IModel)this.nls("commit.cron.enabled.description", new Object[0]));
        CheckBox commitEnabledCron = new CheckBox("commit-cron-enabled", (IModel)commitEnabledModel);
        commitEnabledCronGroup.add(new Component[]{commitEnabledCron});
        this.add(new Component[]{commitEnabledCronGroup});
        if (this.scheduler != null) {
            try {
                Date nextExecution = this.scheduler.nextExecution(updateConfig);
                if (nextExecution != null) {
                    updateCronGroup.setExtraLabel((IModel)this.nls("next.schedule.label", new Object[]{this.format(nextExecution)}));
                }
                if ((nextExecution = this.scheduler.nextExecution(commitConfig)) != null) {
                    commitCronGroup.setExtraLabel((IModel)this.nls("next.schedule.label", new Object[]{this.format(nextExecution)}));
                }
            }
            catch (ScheduleServiceException e) {
                LOG.warn("failed to retrieve next job execution for {}", (Object)updateConfig.absolutePath());
            }
        }
    }

    protected String format(Date nextExecution) {
        long current = System.currentTimeMillis();
        if (nextExecution.getTime() - current < TimeUnit.HOURS.toMillis(23L)) {
            return SimpleDateFormat.getTimeInstance(3, this.getLocale()).format(nextExecution);
        }
        return SimpleDateFormat.getDateTimeInstance(3, 3, this.getLocale()).format(nextExecution);
    }

    public static class TeamSyncJobConfigSection
    extends AbstractConfigSection<ProjectVersion> {
        private static final long serialVersionUID = 1L;

        public WebMarkupContainer doCreateContents(String id, IModel<ProjectVersion> input, Preferences config) {
            return new TeamSyncJobConfigPanel(id, input, config);
        }

        public void commit(IModel<ProjectVersion> input, Preferences config) {
        }

        public String getRequiredPermission() {
            Project project;
            String projectName = null;
            if (this.getDomainObject() != null && (project = this.getParent((IModel<ProjectVersion>)this.getModel())) != null) {
                projectName = project.getName();
            }
            return CommonPermissions.constructPermission((String[])new String[]{"Project", projectName, "config"});
        }

        private Project getParent(IModel<ProjectVersion> domainObject) {
            if (((ProjectVersion)domainObject.getObject()).getParent() != null) {
                return (Project)((ProjectVersion)domainObject.getObject()).getParent();
            }
            if (domainObject instanceof AttachableModel) {
                AttachableModel model = (AttachableModel)domainObject;
                return (Project)model.getParent().getObject();
            }
            return null;
        }

        public boolean isVisible(IModel<ProjectVersion> input, Preferences config) {
            String teamProvider = this.getParent(input).getTeamProvider();
            return super.isVisible(input, config) && teamProvider != null;
        }
    }
}

