/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.git;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.jabylon.common.team.TeamProvider;
import org.jabylon.common.team.TeamProviderException;
import org.jabylon.common.util.PreferencesUtil;
import org.jabylon.properties.DiffKind;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertiesFactory;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.PropertyFileDiff;
import org.jabylon.properties.Workspace;
import org.jabylon.team.git.util.ProgressMonitorWrapper;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class GitTeamProvider
implements TeamProvider {
    @Property(value={"Git"})
    private static String KEY_KIND = "kind";
    private static final Logger LOGGER = LoggerFactory.getLogger(GitTeamProvider.class);

    private Repository createRepository(ProjectVersion project) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File gitDir = new File(project.absoluteFilePath().path());
        Repository repository = ((FileRepositoryBuilder)builder.setGitDir(new File(gitDir, ".git"))).build();
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PropertyFileDiff> update(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<PropertyFileDiff> updatedFiles = new ArrayList<PropertyFileDiff>();
        try {
            Repository repository = this.createRepository(project);
            Git git = Git.wrap((Repository)repository);
            FetchCommand fetchCommand = git.fetch();
            String refspecString = "refs/heads/{0}:refs/remotes/origin/{0}";
            refspecString = MessageFormat.format(refspecString, project.getName());
            RefSpec spec = new RefSpec(refspecString);
            fetchCommand.setRefSpecs(new RefSpec[]{spec});
            subMon.subTask("Fetching from remote");
            fetchCommand.setCredentialsProvider(this.createCredentialsProvider((Project)project.getParent()));
            fetchCommand.setProgressMonitor((ProgressMonitor)new ProgressMonitorWrapper(subMon.newChild(80)));
            fetchCommand.call();
            ObjectId remoteHead = repository.resolve("refs/remotes/origin/" + project.getName() + "^{tree}");
            DiffCommand diff = git.diff();
            subMon.subTask("Caculating Diff");
            diff.setProgressMonitor((ProgressMonitor)new ProgressMonitorWrapper(subMon.newChild(20)));
            diff.setOldTree((AbstractTreeIterator)new FileTreeIterator(repository));
            CanonicalTreeParser p = new CanonicalTreeParser();
            ObjectReader reader = repository.newObjectReader();
            try {
                p.reset(reader, (AnyObjectId)remoteHead);
            }
            finally {
                reader.release();
            }
            diff.setNewTree((AbstractTreeIterator)p);
            this.checkCanceled((IProgressMonitor)subMon);
            List diffs = diff.call();
            for (DiffEntry diffEntry : diffs) {
                this.checkCanceled((IProgressMonitor)subMon);
                updatedFiles.add(this.convertDiffEntry(diffEntry));
                LOGGER.trace(diffEntry.toString());
            }
            if (!updatedFiles.isEmpty()) {
                this.checkCanceled((IProgressMonitor)subMon);
                ObjectId lastCommitID = repository.resolve("refs/remotes/origin/" + project.getName() + "^{commit}");
                LOGGER.info("Merging remote commit {} to {}/{}", new Object[]{lastCommitID, project.getName(), ((Project)project.getParent()).getName()});
                if (this.isRebase(project)) {
                    RebaseCommand rebase = git.rebase();
                    rebase.setUpstream("refs/remotes/origin/" + project.getName());
                    RebaseResult result = rebase.call();
                    if (result.getStatus().isSuccessful()) {
                        LOGGER.info("Rebase finished: {}", (Object)result.getStatus());
                    } else {
                        LOGGER.error("Rebase of {} failed. Attempting abort", (Object)project.relativePath());
                        rebase = git.rebase();
                        rebase.setOperation(RebaseCommand.Operation.ABORT);
                        result = rebase.call();
                        LOGGER.error("Abort finished with {}", (Object)result.getStatus());
                    }
                } else {
                    MergeCommand merge = git.merge();
                    merge.include((AnyObjectId)lastCommitID);
                    MergeResult mergeResult = merge.call();
                    LOGGER.info("Merge finished: {}", (Object)mergeResult.getMergeStatus());
                }
            } else {
                LOGGER.info("Update finished successfully. Nothing to merge, already up to date");
            }
        }
        catch (JGitInternalException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (InvalidRemoteException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (AmbiguousObjectException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamProviderException((Throwable)e);
        }
        finally {
            monitor.done();
        }
        return updatedFiles;
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private PropertyFileDiff convertDiffEntry(DiffEntry diffEntry) {
        PropertyFileDiff diff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
        diff.setOldPath(diffEntry.getOldPath());
        diff.setNewPath(diffEntry.getNewPath());
        DiffKind kind = DiffKind.MODIFY;
        switch (diffEntry.getChangeType()) {
            case ADD: {
                kind = DiffKind.ADD;
                break;
            }
            case COPY: {
                kind = DiffKind.COPY;
                break;
            }
            case DELETE: {
                kind = DiffKind.REMOVE;
                break;
            }
            case MODIFY: {
                kind = DiffKind.MODIFY;
                break;
            }
            case RENAME: {
                kind = DiffKind.MOVE;
            }
        }
        diff.setKind(kind);
        return diff;
    }

    public Collection<PropertyFileDiff> update(PropertyFileDescriptor descriptor, IProgressMonitor monitor) throws TeamProviderException {
        return null;
    }

    public void checkout(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        try {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMon.setTaskName("Checking out");
            subMon.worked(20);
            File repoDir = new File(project.absoluteFilePath().path());
            CloneCommand clone = Git.cloneRepository();
            clone.setBare(false);
            clone.setNoCheckout(false);
            clone.setBranch("refs/heads/" + project.getName());
            clone.setBranchesToClone(Collections.singletonList("refs/heads/" + project.getName()));
            clone.setDirectory(repoDir);
            URI uri = ((Project)project.getParent()).getRepositoryURI();
            clone.setCredentialsProvider(this.createCredentialsProvider((Project)project.getParent()));
            clone.setURI(this.stripUserInfo(uri).toString());
            clone.setProgressMonitor((ProgressMonitor)new ProgressMonitorWrapper(subMon.newChild(70)));
            clone.call();
            subMon.done();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (TransportException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (InvalidRemoteException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TeamProviderException((Throwable)e);
        }
    }

    public void commit(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        try {
            Repository repository = this.createRepository(project);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Commit", (int)100);
            Git git = new Git(repository);
            List<String> changedFiles = this.addNewFiles(git, (IProgressMonitor)subMon.newChild(30));
            if (!changedFiles.isEmpty()) {
                this.checkCanceled((IProgressMonitor)subMon);
                CommitCommand commit = git.commit();
                Preferences node = PreferencesUtil.scopeFor((Object)project.getParent());
                String username = node.get("git.username", "Jabylon");
                String email = node.get("git.email", "jabylon@example.org");
                String message = node.get("git.message", "Auto Sync-up by Jabylon");
                commit.setAuthor(username, email);
                commit.setCommitter(username, email);
                commit.setMessage(message);
                for (String path : changedFiles) {
                    this.checkCanceled((IProgressMonitor)subMon);
                    commit.setOnly(path);
                }
                commit.call();
                subMon.worked(10);
            } else {
                LOGGER.info("No changed files, skipping commit phase");
            }
            this.checkCanceled((IProgressMonitor)subMon);
            PushCommand push = git.push();
            push.setProgressMonitor((ProgressMonitor)new ProgressMonitorWrapper(subMon.newChild(60)));
            push.setCredentialsProvider(this.createCredentialsProvider((Project)project.getParent()));
            RefSpec spec = this.createRefSpec(project);
            push.setRefSpecs(new RefSpec[]{spec});
            Iterable result = push.call();
            for (PushResult r : result) {
                for (RemoteRefUpdate rru : r.getRemoteUpdates()) {
                    if (rru.getStatus() == RemoteRefUpdate.Status.OK || rru.getStatus() == RemoteRefUpdate.Status.UP_TO_DATE) continue;
                    String error = "Push failed: " + rru.getStatus();
                    LOGGER.error(error);
                    throw new TeamProviderException(error);
                }
            }
            Ref ref = repository.getRef(project.getName());
            if (ref != null) {
                LOGGER.info("Successfully pushed {} to {}", (Object)ref.getObjectId(), (Object)((Project)project.getParent()).getRepositoryURI());
            }
        }
        catch (NoHeadException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (NoMessageException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (ConcurrentRefUpdateException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (JGitInternalException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (WrongRepositoryStateException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (InvalidRemoteException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamProviderException((Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TeamProviderException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private RefSpec createRefSpec(ProjectVersion version) {
        Preferences node = PreferencesUtil.scopeFor((Object)version);
        String refSpecString = node.get("git.push.refspec", "refs/heads/{0}:refs/heads/{0}");
        if (refSpecString.isEmpty()) {
            refSpecString = "refs/heads/{0}:refs/heads/{0}";
        }
        refSpecString = MessageFormat.format(refSpecString, version.getName());
        return new RefSpec(refSpecString);
    }

    private boolean isRebase(ProjectVersion version) {
        Preferences node = PreferencesUtil.scopeFor((Object)version);
        return node.getBoolean("git.rebase", true);
    }

    private List<String> addNewFiles(Git git, IProgressMonitor monitor) throws IOException, GitAPIException {
        monitor.beginTask("Creating Diff", 100);
        DiffCommand diffCommand = git.diff();
        AddCommand addCommand = git.add();
        ArrayList<String> changedFiles = new ArrayList<String>();
        ArrayList<String> newFiles = new ArrayList<String>();
        List result = diffCommand.call();
        for (DiffEntry diffEntry : result) {
            this.checkCanceled(monitor);
            if (diffEntry.getChangeType() == DiffEntry.ChangeType.ADD) {
                addCommand.addFilepattern(diffEntry.getNewPath());
                newFiles.add(diffEntry.getNewPath());
                monitor.subTask(diffEntry.getNewPath());
            } else if (diffEntry.getChangeType() == DiffEntry.ChangeType.MODIFY) {
                monitor.subTask(diffEntry.getOldPath());
                changedFiles.add(diffEntry.getOldPath());
            }
            monitor.worked(0);
        }
        if (!newFiles.isEmpty()) {
            addCommand.call();
        }
        changedFiles.addAll(newFiles);
        monitor.done();
        return changedFiles;
    }

    public void commit(PropertyFileDescriptor descriptor, IProgressMonitor monitor) throws TeamProviderException {
    }

    public Collection<PropertyFileDiff> reset(ProjectVersion project, IProgressMonitor monitor) throws TeamProviderException {
        ArrayList<PropertyFileDiff> updatedFiles = new ArrayList<PropertyFileDiff>();
        try {
            Repository repository = this.createRepository(project);
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Reset", (int)100);
            Git git = new Git(repository);
            subMon.subTask("Calculating Diff");
            DiffCommand diffCommand = git.diff();
            diffCommand.setProgressMonitor((ProgressMonitor)new ProgressMonitorWrapper(subMon.newChild(30)));
            diffCommand.setOldTree(GitTeamProvider.prepareTreeParser(repository, "refs/remotes/origin/" + project.getName()));
            diffCommand.setNewTree(null);
            List diffs = diffCommand.call();
            for (DiffEntry diffEntry : diffs) {
                this.checkCanceled(monitor);
                PropertyFileDiff fileDiff = this.createDiff(diffEntry, monitor);
                this.revertDiff(fileDiff);
                updatedFiles.add(fileDiff);
            }
            subMon.subTask("Executing Reset");
            ResetCommand reset = git.reset();
            reset.setMode(ResetCommand.ResetType.HARD);
            reset.setRef("refs/remotes/origin/" + project.getName());
            reset.call();
            CleanCommand clean = git.clean();
            clean.setCleanDirectories(true);
            Set call = clean.call();
            LOGGER.info("cleaned " + call);
        }
        catch (IOException e) {
            LOGGER.error("reset failed", (Throwable)e);
            throw new TeamProviderException((Throwable)e);
        }
        catch (GitAPIException e) {
            LOGGER.error("reset failed", (Throwable)e);
            throw new TeamProviderException((Throwable)e);
        }
        return updatedFiles;
    }

    private PropertyFileDiff createDiff(DiffEntry diffEntry, IProgressMonitor monitor) {
        PropertyFileDiff fileDiff = PropertiesFactory.eINSTANCE.createPropertyFileDiff();
        switch (diffEntry.getChangeType()) {
            case ADD: {
                monitor.subTask(diffEntry.getNewPath());
                fileDiff.setKind(DiffKind.ADD);
                fileDiff.setNewPath(diffEntry.getNewPath());
                return fileDiff;
            }
            case COPY: {
                monitor.subTask(diffEntry.getNewPath());
                fileDiff.setKind(DiffKind.COPY);
                fileDiff.setNewPath(diffEntry.getNewPath());
                fileDiff.setOldPath(diffEntry.getOldPath());
                return fileDiff;
            }
            case DELETE: {
                monitor.subTask(diffEntry.getOldPath());
                fileDiff.setKind(DiffKind.REMOVE);
                fileDiff.setOldPath(diffEntry.getOldPath());
                return fileDiff;
            }
            case MODIFY: {
                monitor.subTask(diffEntry.getNewPath());
                fileDiff.setKind(DiffKind.MODIFY);
                fileDiff.setOldPath(diffEntry.getOldPath());
                fileDiff.setNewPath(diffEntry.getNewPath());
                return fileDiff;
            }
            case RENAME: {
                monitor.subTask(diffEntry.getNewPath());
                fileDiff.setKind(DiffKind.MOVE);
                fileDiff.setOldPath(diffEntry.getOldPath());
                fileDiff.setNewPath(diffEntry.getOldPath());
                return fileDiff;
            }
        }
        return fileDiff;
    }

    private void revertDiff(PropertyFileDiff diff) {
        String path1 = diff.getNewPath();
        String path2 = diff.getOldPath();
        diff.setOldPath(path1);
        diff.setNewPath(path2);
        switch (diff.getKind()) {
            case REMOVE: {
                diff.setKind(DiffKind.ADD);
                break;
            }
            case ADD: {
                diff.setKind(DiffKind.REMOVE);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractTreeIterator prepareTreeParser(Repository repository, String ref) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        Ref head = repository.getRef(ref);
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
        RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
        CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
        ObjectReader oldReader = repository.newObjectReader();
        try {
            oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
        }
        finally {
            oldReader.release();
        }
        return oldTreeParser;
    }

    public static void main(String[] args) throws IOException, JGitInternalException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        Workspace workspace = PropertiesFactory.eINSTANCE.createWorkspace();
        workspace.setRoot(URI.createFileURI((String)new File("target/test").getAbsolutePath()));
        Project project = PropertiesFactory.eINSTANCE.createProject();
        project.setName("jabylon3");
        workspace.getChildren().add((Object)project);
        ProjectVersion version = PropertiesFactory.eINSTANCE.createProjectVersion();
        version.setName("master");
        project.getChildren().add((Object)version);
        GitTeamProvider provider = new GitTeamProvider();
        provider.commit(version, null);
    }

    private CredentialsProvider createCredentialsProvider(Project project) {
        Preferences node = PreferencesUtil.scopeFor((Object)project);
        String username = node.get("git.username", "");
        String password = node.get("git.password", "");
        return new UsernamePasswordCredentialsProvider(username, password);
    }

    private URI stripUserInfo(URI uri) {
        if (uri.userInfo() != null && uri.userInfo().length() > 0) {
            String userInfo = uri.userInfo();
            URI strippedUri = URI.createHierarchicalURI((String)uri.scheme(), (String)uri.authority().replace(userInfo + "@", ""), (String)uri.device(), (String[])uri.segments(), (String)uri.query(), (String)uri.fragment());
            return strippedUri;
        }
        return uri;
    }
}

