/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.team.git.util;

import java.text.MessageFormat;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;

public class ProgressMonitorWrapper
implements ProgressMonitor {
    private SubMonitor delegate;
    private SubMonitor currentChild;
    private static final String SUB_TASK_MESSAGE = "{0} of {1}";
    private int remainingTicks;
    int total;
    int current;

    public ProgressMonitorWrapper(SubMonitor delegate) {
        this.delegate = delegate;
    }

    public void start(int totalTasks) {
        this.remainingTicks = totalTasks * 100;
        this.delegate.setWorkRemaining(this.remainingTicks);
    }

    public void beginTask(String title, int totalWork) {
        if (this.currentChild != null) {
            this.currentChild.done();
        }
        this.total = totalWork;
        this.current = 0;
        if (totalWork <= 0) {
            this.currentChild = this.delegate.newChild(0);
            this.currentChild.beginTask(title, 100);
        } else {
            this.currentChild = this.delegate.newChild(100);
            this.currentChild.beginTask(title, totalWork);
        }
        this.delegate.setTaskName(title);
    }

    public void update(int completed) {
        this.current += completed;
        if (this.currentChild != null) {
            this.currentChild.worked(completed);
        } else {
            this.delegate.worked(completed);
        }
        this.delegate.subTask(MessageFormat.format(SUB_TASK_MESSAGE, this.current, this.total));
    }

    public void endTask() {
        if (this.currentChild != null) {
            this.currentChild.done();
        }
        this.currentChild = null;
    }

    public boolean isCancelled() {
        return this.delegate.isCanceled();
    }
}

