/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.db2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.Table;
import com.googlecode.flyway.core.dbsupport.db2.DB2Table;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2Schema
extends Schema {
    public DB2Schema(JdbcTemplate jdbcTemplate, DbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM syscat.schemata WHERE schemaname=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from syscat.tables where tabschema = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.views where viewschema = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.sequences where seqschema = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.indexes where indschema = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.procedures where procschema = ?", this.name);
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.functions where funcschema = ?", this.name)) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + this.dbSupport.quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + this.dbSupport.quote(this.name) + " RESTRICT", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String dropStatement : this.generateDropStatements(this.name, "V", "VIEW")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements(this.name, "A", "ALIAS")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
        for (String dropStatement : this.generateDropStatementsForSequences(this.name)) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForProcedures(this.name)) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForFunctions(this.name)) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForFunctions(String schema) throws SQLException {
        String dropFuncGenQuery = "select rtrim(FUNCNAME) from SYSCAT.FUNCTIONS where FUNCSCHEMA = '" + schema + "'";
        return this.buildDropStatements("DROP FUNCTION", dropFuncGenQuery, schema);
    }

    private List<String> generateDropStatementsForProcedures(String schema) throws SQLException {
        String dropProcGenQuery = "select rtrim(PROCNAME) from SYSCAT.PROCEDURES where PROCSCHEMA = '" + schema + "'";
        return this.buildDropStatements("DROP PROCEDURE", dropProcGenQuery, schema);
    }

    private List<String> generateDropStatementsForSequences(String schema) throws SQLException {
        String dropSeqGenQuery = "select rtrim(SEQNAME) from SYSCAT.SEQUENCES where SEQSCHEMA = '" + schema + "' and SEQTYPE='S'";
        return this.buildDropStatements("DROP SEQUENCE", dropSeqGenQuery, schema);
    }

    private List<String> generateDropStatements(String schema, String tableType, String objectType) throws SQLException {
        String dropTablesGenQuery = "select rtrim(TABNAME) from SYSCAT.TABLES where TYPE='" + tableType + "' and TABSCHEMA = '" + schema + "'";
        return this.buildDropStatements("DROP " + objectType, dropTablesGenQuery, schema);
    }

    private List<String> buildDropStatements(String dropPrefix, String query, String schema) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> dbObjects = this.jdbcTemplate.queryForStringList(query, new String[0]);
        for (String dbObject : dbObjects) {
            dropStatements.add(dropPrefix + " " + this.dbSupport.quote(schema, dbObject));
        }
        return dropStatements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("select rtrim(TABNAME) from SYSCAT.TABLES where TYPE='T' and TABSCHEMA = ?", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new DB2Table(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new DB2Table(this.jdbcTemplate, this.dbSupport, this, tableName);
    }
}

