/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;

public final class DelegatingDBTable
extends DelegatingDBSchemaElement
implements InternalDBTable {
    DelegatingDBTable(InternalDBTable delegate) {
        super(delegate);
    }

    public InternalDBTable getDelegate() {
        return (InternalDBTable)super.getDelegate();
    }

    public void setDelegate(IDBSchemaElement delegate) {
        IDBField[] wrapperFields = this.getFields();
        IDBIndex[] wrapperIndices = this.getIndices();
        IDBTable delegateTable = (IDBTable)delegate;
        super.setDelegate(delegateTable);
        IDBSchemaElement[] iDBSchemaElementArray = wrapperFields;
        int n = wrapperFields.length;
        int n2 = 0;
        while (n2 < n) {
            IDBField wrapperField = iDBSchemaElementArray[n2];
            IDBField delegateField = delegateTable.getField(wrapperField.getName());
            ((DelegatingDBSchemaElement)((Object)wrapperField)).setDelegate(delegateField);
            ++n2;
        }
        iDBSchemaElementArray = wrapperIndices;
        n = wrapperIndices.length;
        n2 = 0;
        while (n2 < n) {
            IDBSchemaElement wrapperIndex = iDBSchemaElementArray[n2];
            IDBIndex delegateIndex = delegateTable.getIndex(wrapperIndex.getName());
            ((DelegatingDBSchemaElement)wrapperIndex).setDelegate(delegateIndex);
            ++n2;
        }
    }

    public IDBTable getWrapper() {
        return this;
    }

    public IDBSchema getParent() {
        return DelegatingDBTable.wrap(this.getDelegate().getParent());
    }

    public IDBField addField(String name, DBType type) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type));
    }

    public IDBField addField(String name, DBType type, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, notNull));
    }

    public void removeField(IDBField fieldToRemove) {
        this.getDelegate().removeField(DelegatingDBTable.unwrap(fieldToRemove));
    }

    public IDBField addField(String name, DBType type, int precision) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision));
    }

    public void removeIndex(IDBIndex indexToRemove) {
        this.getDelegate().removeIndex(DelegatingDBTable.unwrap(indexToRemove));
    }

    public IDBField addField(String name, DBType type, int precision, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, notNull));
    }

    public IDBField addField(String name, DBType type, int precision, int scale) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, scale));
    }

    public IDBField addField(String name, DBType type, int precision, int scale, boolean notNull) {
        return DelegatingDBTable.wrap(this.getDelegate().addField(name, type, precision, scale, notNull));
    }

    public IDBField getFieldSafe(String name) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().getFieldSafe(name));
    }

    public IDBField getField(String name) {
        return DelegatingDBTable.wrap(this.getDelegate().getField(name));
    }

    public IDBField getField(int position) {
        return DelegatingDBTable.wrap(this.getDelegate().getField(position));
    }

    public int getFieldCount() {
        return this.getDelegate().getFieldCount();
    }

    public IDBField[] getFields() {
        return (IDBField[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getFields(), IDBField.class);
    }

    public IDBField[] getFields(String ... fieldNames) throws SchemaElementNotFoundException {
        return (IDBField[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getFields(fieldNames), IDBField.class);
    }

    public IDBIndex addIndex(String name, IDBIndex.Type type, IDBField ... fields) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(name, type, (IDBField[])DelegatingDBTable.unwrap((IDBSchemaElement[])fields, IDBField.class)));
    }

    public IDBIndex addIndex(String name, IDBIndex.Type type, String ... fieldNames) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(name, type, fieldNames));
    }

    public IDBIndex addIndexEmpty(String name, IDBIndex.Type type) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndexEmpty(name, type));
    }

    public IDBIndex addIndex(IDBIndex.Type type, IDBField ... fields) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(type, (IDBField[])DelegatingDBTable.unwrap((IDBSchemaElement[])fields, IDBField.class)));
    }

    public IDBIndex addIndex(IDBIndex.Type type, String ... fieldNames) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().addIndex(type, fieldNames));
    }

    public IDBIndex addIndexEmpty(IDBIndex.Type type) {
        return DelegatingDBTable.wrap(this.getDelegate().addIndexEmpty(type));
    }

    public IDBIndex getIndexSafe(String name) throws SchemaElementNotFoundException {
        return DelegatingDBTable.wrap(this.getDelegate().getIndexSafe(name));
    }

    public IDBIndex getIndex(String name) {
        return DelegatingDBTable.wrap(this.getDelegate().getIndex(name));
    }

    public IDBIndex getIndex(int position) {
        return DelegatingDBTable.wrap(this.getDelegate().getIndex(position));
    }

    public int getIndexCount() {
        return this.getDelegate().getIndexCount();
    }

    public IDBIndex[] getIndices() {
        return (IDBIndex[])DelegatingDBTable.wrap((IDBSchemaElement[])this.getDelegate().getIndices(), IDBIndex.class);
    }

    public IDBIndex getPrimaryKeyIndex() {
        return DelegatingDBTable.wrap(this.getDelegate().getPrimaryKeyIndex());
    }

    public String sqlInsert() {
        return this.getDelegate().sqlInsert();
    }
}

