/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.security;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.jabylon.properties.PropertiesPackage;
import org.jabylon.properties.Resolvable;
import org.jabylon.properties.Workspace;
import org.jabylon.users.Permission;
import org.jabylon.users.Role;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersFactory;

public class CommonPermissions {
    public static final String WILDCARD = "*";
    public static final String ROLE_ANONYMOUS = "Anonymous";
    public static final String ROLE_REGISTERED = "Registered";
    public static final String ROLE_ADMINISTRATOR = "Administrator";
    public static final String USER_ANONYMOUS = "Anonymous";
    public static final String PROJECT = "Project";
    public static final String WORKSPACE = "Workspace";
    public static final String USER = "User";
    public static final String SYSTEM = "System";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_CONFIG = "config";
    public static final String ACTION_SUGGEST = "suggest";
    public static final String PROJECT_GLOBAL_CONFIG = "Project:*:config";
    public static final String PROJECT_GLOBAL_VIEW = "Project:*:view";
    public static final String PROJECT_GLOBAL_EDIT = "Project:*:edit";
    public static final String WORKSPACE_CONFIG = "Workspace:config";
    public static final String AUTH_TYPE_LDAP = "LDAP";
    public static final String AUTH_TYPE_DB = "DB";
    public static final String SYSTEM_GLOBAL_CONFIG = "System:*:config";
    public static final String USER_GLOBAL_CONFIG = "User:*:config";
    @Deprecated
    public static final String SYSTEM_GENERAL_CONFIG = "System:config";
    private static final String PERMISSION_PATTERN = "{0}:{1}:{2}";
    private static final String WORKSPACE_PERMISSION_PATTERN = "{0}:{1}";
    private static final Set<EClass> KNOWN_TARGETS = new HashSet<EClass>();

    private static Resolvable<?, ?> getActualTarget(Resolvable<?, ?> target) {
        Resolvable current;
        for (current = target; current != null && !KNOWN_TARGETS.contains(current.eClass()); current = current.getParent()) {
        }
        return current;
    }

    public static String constructPermissionName(String kind, String scope, String action) {
        return MessageFormat.format(PERMISSION_PATTERN, kind, scope, action);
    }

    public static String constructPermissionName(Resolvable<?, ?> r, String action) {
        Resolvable<?, ?> rightsContainer = CommonPermissions.getActualTarget(r);
        if (rightsContainer instanceof Workspace) {
            return MessageFormat.format(WORKSPACE_PERMISSION_PATTERN, r.eClass().getName(), action);
        }
        return CommonPermissions.constructPermissionName(rightsContainer.eClass().getName(), rightsContainer.getName(), action);
    }

    public static boolean hasPermission(User user, String permission) {
        return user.hasPermission(permission);
    }

    public static boolean hasPermission(User user, Resolvable<?, ?> r, String action) {
        return user.hasPermission(CommonPermissions.constructPermissionName(r, action));
    }

    public static boolean hasEditPermission(User user, Resolvable<?, ?> r) {
        return user.hasPermission(CommonPermissions.constructPermissionName(r, ACTION_EDIT));
    }

    public static boolean hasViewPermission(User user, Resolvable<?, ?> r) {
        return user.hasPermission(CommonPermissions.constructPermissionName(r, ACTION_VIEW));
    }

    public static boolean hasConfigPermission(User user, Resolvable<?, ?> r) {
        return user.hasPermission(CommonPermissions.constructPermissionName(r, ACTION_CONFIG));
    }

    public static String constructPermission(String ... parts) {
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part);
            builder.append(":");
        }
        if (builder.length() != 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static boolean isEditRequest(String permission) {
        return permission.contains(":edit");
    }

    public static void addDefaultPermissions(UserManagement userManagement, User user) {
        String name = user.getName();
        String selfEdit = CommonPermissions.constructPermission(USER, name, ACTION_CONFIG);
        Permission selfEditPermission = userManagement.findPermissionByName(selfEdit);
        if (selfEditPermission == null) {
            selfEditPermission = UsersFactory.eINSTANCE.createPermission();
            selfEditPermission.setName(selfEdit);
            userManagement.getPermissions().add((Object)selfEditPermission);
        }
        user.getPermissions().add((Object)selfEditPermission);
        Role registeredRole = userManagement.findRoleByName(ROLE_REGISTERED);
        if (registeredRole == null) {
            throw new RuntimeException("Registered role must always exist");
        }
        user.getRoles().add((Object)registeredRole);
        Role anonymousRole = userManagement.findRoleByName("Anonymous");
        if (anonymousRole == null) {
            throw new RuntimeException("Anonymous role must always exist");
        }
        user.getRoles().add((Object)anonymousRole);
    }

    static {
        KNOWN_TARGETS.add(PropertiesPackage.Literals.WORKSPACE);
        KNOWN_TARGETS.add(PropertiesPackage.Literals.PROJECT);
    }
}

