/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.security.auth;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.jabylon.cdo.connector.Modification;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.cdo.connector.TransactionUtil;
import org.jabylon.cdo.server.ServerConstants;
import org.jabylon.security.CommonPermissions;
import org.jabylon.security.JabylonSecurityBundle;
import org.jabylon.security.SubjectAttribute;
import org.jabylon.security.auth.AuthenticationService;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class AuthenticatorServiceImpl
implements AuthenticationService {
    private Logger logger = LoggerFactory.getLogger(AuthenticatorServiceImpl.class);
    private static final String JAAS_CONFIG_FILE = "jaas.config";
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setRepositoryConnector", unbind="unbindRepositoryConnector")
    private RepositoryConnector repositoryConnector;
    private UserManagement userManagement;
    private User anonymous;

    @Override
    public boolean authenticate(String username, String password) {
        Subject subject = this.doAuthenticate(username, password);
        return subject != null;
    }

    protected Subject doAuthenticate(final String username, final String password) {
        ILoginContext context = this.createLoginContext(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    Callback cb = callbacks[i];
                    if (cb instanceof NameCallback) {
                        ((NameCallback)cb).setName(username);
                        continue;
                    }
                    if (!(cb instanceof PasswordCallback)) continue;
                    ((PasswordCallback)cb).setPassword(password.toCharArray());
                }
            }
        });
        try {
            context.login();
            Subject subject = context.getSubject();
            Set<String> credentials = subject.getPublicCredentials(String.class);
            String actualUsername = credentials.isEmpty() ? username : credentials.iterator().next();
            this.logger.info("Login for user {} successful", (Object)actualUsername);
            return subject;
        }
        catch (LoginException e) {
            this.logger.error("Login for user " + username + " failed: " + e.getMessage());
            return null;
        }
    }

    @Override
    public User authenticateUser(String username, String password) {
        UserManagement management;
        String actualUsername = username;
        final Subject subject = this.doAuthenticate(username, password);
        if (subject == null) {
            return null;
        }
        Set<String> credentials = subject.getPublicCredentials(String.class);
        if (!credentials.isEmpty()) {
            actualUsername = credentials.iterator().next();
        }
        if ((management = this.getUserManagement()) == null) {
            return null;
        }
        User user = management.findUserByName(actualUsername);
        try {
            if (user == null) {
                this.logger.info("User {} logged in for the first time. Creating DB Entry", (Object)actualUsername);
                final User newUser = UsersFactory.eINSTANCE.createUser();
                newUser.setName(actualUsername);
                user = (User)TransactionUtil.commit((EObject)management, (Modification)new Modification<UserManagement, User>(){

                    public User apply(UserManagement object) {
                        CommonPermissions.addDefaultPermissions(object, newUser);
                        AuthenticatorServiceImpl.this.applyAttributes(newUser, subject);
                        object.getUsers().add((Object)newUser);
                        return newUser;
                    }
                });
            } else {
                user = (User)TransactionUtil.commit((EObject)user, (Modification)new Modification<User, User>(){

                    public User apply(User object) {
                        AuthenticatorServiceImpl.this.applyAttributes(object, subject);
                        return object;
                    }
                });
            }
        }
        catch (CommitException e) {
            this.logger.error("Failed to commit new user or updating exsiting after login", (Throwable)e);
        }
        return user;
    }

    protected void applyAttributes(User user, Subject subject) {
        Set<SubjectAttribute> attributes = subject.getPublicCredentials(SubjectAttribute.class);
        for (SubjectAttribute subjectAttribute : attributes) {
            subjectAttribute.applyTo((EObject)user);
        }
    }

    private ILoginContext createLoginContext(CallbackHandler callbackHandler) {
        URL configUrl = this.getJAASConfig();
        return LoginContextFactory.createContext((String)"Jabylon", (URL)configUrl, (CallbackHandler)callbackHandler);
    }

    private URL getJAASConfig() {
        String configArea = System.getProperty("osgi.configuration.area");
        if (configArea == null || configArea.isEmpty()) {
            configArea = new File(new File(ServerConstants.WORKING_DIR), "configuration").toURI().toString();
        }
        try {
            URI uri = new URI(configArea);
            File jaasConfig = new File(new File(uri), JAAS_CONFIG_FILE);
            if (jaasConfig.isFile()) {
                return jaasConfig.toURI().toURL();
            }
        }
        catch (Exception e) {
            this.logger.error("invalid jaas url", (Throwable)e);
        }
        return JabylonSecurityBundle.getBundleContext().getBundle().getEntry("META-INF/jaas.config");
    }

    private UserManagement getUserManagement() {
        if (this.userManagement == null) {
            Object resolved = this.getRepositoryConnector().openView().getResource("users").getContents().get(0);
            if (resolved instanceof UserManagement) {
                this.userManagement = (UserManagement)resolved;
            } else {
                this.logger.error("Failed to obtain UserManagement");
            }
        }
        return this.userManagement;
    }

    public RepositoryConnector getRepositoryConnector() {
        return this.repositoryConnector;
    }

    public void setRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    public void unbindRepositoryConnector(RepositoryConnector repositoryConnector) {
        if (repositoryConnector == this.repositoryConnector) {
            if (this.userManagement != null) {
                this.userManagement.cdoView().close();
            }
            this.userManagement = null;
            this.repositoryConnector = null;
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.userManagement != null) {
            this.userManagement.cdoView().close();
        }
        this.userManagement = null;
    }

    @Override
    public User getAnonymousUser() {
        if (this.anonymous == null) {
            this.anonymous = this.getUserManagement().findUserByName("Anonymous");
        }
        return this.anonymous;
    }
}

