/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.security.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.security.JabylonSecurityBundle;
import org.jabylon.security.SubjectAttribute;
import org.jabylon.users.Permission;
import org.jabylon.users.User;
import org.jabylon.users.UserManagement;
import org.jabylon.users.UsersPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLoginModule
implements LoginModule {
    static final String EMPTY_STRING = "";
    Subject subj;
    CallbackHandler cbHandler;
    boolean authenticated = false;
    String user;
    String pw;
    List<Permission> permissions = new ArrayList<Permission>();
    private static final Logger logger = LoggerFactory.getLogger(DBLoginModule.class);

    @Override
    public boolean abort() throws LoginException {
        this.authenticated = false;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticated) {
            this.subj.getPublicCredentials().remove(this.user);
            this.subj.getPrivateCredentials().removeAll(this.permissions);
            this.permissions = new ArrayList<Permission>();
            return false;
        }
        this.subj.getPublicCredentials().add(this.user);
        this.addPermissions(this.subj.getPrivateCredentials());
        return true;
    }

    private void addPermissions(Set<Object> privateCredentials) {
        for (Permission permission : this.permissions) {
            privateCredentials.add(permission);
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subj = subject;
        this.cbHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("User:");
        PasswordCallback passwordCallback = new PasswordCallback("Password:", false);
        try {
            this.cbHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            logger.error("Login failed", (Throwable)e);
        }
        this.user = nameCallback.getName();
        this.pw = EMPTY_STRING;
        if (passwordCallback.getPassword() != null) {
            this.pw = String.valueOf(passwordCallback.getPassword());
        }
        this.authenticated = this.checkLogin(this.user, this.pw);
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLogin(String userName, String pw) {
        if (JabylonSecurityBundle.getRepositoryConnector() == null) {
            return false;
        }
        CDOView view = JabylonSecurityBundle.getRepositoryConnector().openView();
        try {
            boolean valid = false;
            User user = null;
            UserManagement userManagement = (UserManagement)view.getResource("users").getContents().get(0);
            if (userName == null || userName.isEmpty()) {
                user = userManagement.findUserByToken(pw);
                if (user != null) {
                    this.user = user.getName();
                    valid = true;
                }
            } else {
                user = userManagement.findUserByName(userName);
                boolean bl = valid = pw != null && !pw.isEmpty() && user != null && pw.equals(user.getPassword());
                if (valid && !"DB".equals(user.getType())) {
                    logger.warn("User {} does not have the auth type DB set");
                    this.subj.getPublicCredentials().add(new SubjectAttribute((EStructuralFeature)UsersPackage.Literals.USER__TYPE, "DB"));
                }
            }
            if (user == null || !valid) {
                logger.info("DB Login failed for user {}", (Object)userName);
                boolean bl = false;
                return bl;
            }
            this.permissions = user.getAllPermissions();
            logger.info("DB Login for user {} successful", (Object)userName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Login failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            view.close();
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.authenticated = false;
        return true;
    }
}

