/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.security.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.jabylon.security.SubjectAttribute;
import org.jabylon.users.UsersPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPLoginModule
implements LoginModule {
    public static final String KEY_LDAP = "ldap";
    public static final String KEY_LDAP_PORT = "ldap.port";
    public static final String KEY_USER_NAME = "user.id";
    public static final String KEY_USER_FULL_NAME = "user.name";
    public static final String KEY_USER_MAIL = "user.mail";
    public static final String KEY_ROOT_DN = "root.dn";
    public static final String KEY_MANAGER = "manager";
    public static final String KEY_MANAGER_PASSWORD = "manager.password";
    private Subject subj;
    private CallbackHandler cbHandler;
    private Map<String, ?> options;
    private boolean authenticated;
    private String user;
    private static final Logger logger = LoggerFactory.getLogger(LDAPLoginModule.class);
    private DirContext ctx;
    private String email;
    private String fullName;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subj = subject;
        this.cbHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("User:");
        PasswordCallback passwordCallback = new PasswordCallback("Password:", false);
        try {
            this.cbHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            logger.error("Login failed", (Throwable)e);
        }
        this.user = nameCallback.getName();
        String pw = null;
        if (passwordCallback.getPassword() != null) {
            pw = String.valueOf(passwordCallback.getPassword());
        }
        this.authenticated = this.checkLogin(this.user, pw);
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLogin(String user, String pw) {
        this.ctx = this.createContext((String)this.options.get(KEY_MANAGER), (String)this.options.get(KEY_MANAGER_PASSWORD));
        if (this.ctx != null) {
            try {
                DirContext context;
                String userDN = this.findUser(user, this.ctx);
                if (userDN != null && (context = this.createContext(userDN, pw)) != null) {
                    context.close();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (NamingException e) {
                logger.error("LDAP search failed for user " + user, (Throwable)e);
            }
            finally {
                try {
                    this.ctx.close();
                }
                catch (NamingException e) {
                    logger.error("Failed to close directory context", (Throwable)e);
                }
            }
        }
        return false;
    }

    private String findUser(String user, DirContext ctx) throws NamingException {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(this.getUserAttributes());
        String filter = MessageFormat.format("({0}={1})", this.options.get(KEY_USER_NAME), user);
        NamingEnumeration<SearchResult> result = ctx.search("", filter, controls);
        if (result.hasMore()) {
            Attribute attribute;
            SearchResult searchResult = result.next();
            String userId = searchResult.getNameInNamespace();
            Attributes attributes = searchResult.getAttributes();
            if (this.options.get(KEY_USER_MAIL) instanceof String && (attribute = attributes.get((String)this.options.get(KEY_USER_MAIL))) != null) {
                this.email = (String)attribute.get();
            }
            if (this.options.get(KEY_USER_FULL_NAME) instanceof String && (attribute = attributes.get((String)this.options.get(KEY_USER_FULL_NAME))) != null) {
                this.fullName = (String)attribute.get();
            }
            return userId;
        }
        return null;
    }

    private String[] getUserAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.options.get(KEY_USER_MAIL) instanceof String) {
            attributes.add((String)this.options.get(KEY_USER_MAIL));
        }
        if (this.options.get(KEY_USER_FULL_NAME) instanceof String) {
            attributes.add((String)this.options.get(KEY_USER_FULL_NAME));
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    public DirContext createContext(String userDN, String userPassword) {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String providerUrl = MessageFormat.format("ldap://{0}:{1}/{2}", this.options.get(KEY_LDAP), this.options.get(KEY_LDAP_PORT), this.options.get(KEY_ROOT_DN));
        env.put("java.naming.provider.url", providerUrl);
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", userPassword);
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            logger.warn("Cannot bind user with userDN = " + userDN + " with exception " + e.getLocalizedMessage());
        }
        return ctx;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.authenticated) {
            this.subj.getPublicCredentials().add(this.user);
            if (this.email != null && !this.email.isEmpty()) {
                this.subj.getPublicCredentials().add(new SubjectAttribute((EStructuralFeature)UsersPackage.Literals.USER__EMAIL, this.email));
            }
            if (this.fullName != null && !this.fullName.isEmpty()) {
                this.subj.getPublicCredentials().add(new SubjectAttribute((EStructuralFeature)UsersPackage.Literals.USER__DISPLAY_NAME, this.fullName));
            }
        } else {
            this.subj.getPublicCredentials().remove(this.user);
            return false;
        }
        this.subj.getPublicCredentials().add(new SubjectAttribute((EStructuralFeature)UsersPackage.Literals.USER__TYPE, "LDAP"));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.authenticated = false;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.authenticated = false;
        return true;
    }
}

