/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.index.properties;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.Plugin;
import org.jabylon.cdo.server.ServerConstants;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexActivator
extends Plugin
implements BundleActivator {
    private static IndexActivator INSTANCE;
    private FSDirectory directory;
    public static final String PLUGIN_ID = "org.jabylon.index";
    private static final Logger logger;
    private int indexWriterCount = 0;
    private IndexWriter indexWriter;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.directory != null) {
            this.directory.close();
        }
        INSTANCE = null;
        this.directory = null;
        logger.info("Stopping Lucene Index");
    }

    public Directory getOrCreateDirectory() {
        if (this.directory == null) {
            try {
                logger.info("Opening Lucene Index");
                File file = new File(ServerConstants.WORKING_DIR, "lucene");
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.directory = FSDirectory.open((File)new File(ServerConstants.WORKING_DIR, "lucene"));
            }
            catch (IOException e) {
                logger.error("Failed to open index directory", (Throwable)e);
            }
        }
        return this.directory;
    }

    public synchronized IndexWriter obtainIndexWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        ++this.indexWriterCount;
        if (this.indexWriter == null) {
            IndexWriterConfig c = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new StandardAnalyzer(Version.LUCENE_35));
            this.indexWriter = new IndexWriter(this.getOrCreateDirectory(), c);
        }
        return this.indexWriter;
    }

    public synchronized void returnIndexWriter(IndexWriter writer) throws CorruptIndexException, IOException {
        if (writer != this.indexWriter) {
            throw new IllegalStateException("The given index writer is not the current index writer");
        }
        --this.indexWriterCount;
        if (this.indexWriterCount == 0 && this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    public static IndexActivator getDefault() {
        return INSTANCE;
    }

    static {
        logger = LoggerFactory.getLogger(IndexActivator.class);
    }
}

