/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.index.properties.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.common.util.EList;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.Property;
import org.jabylon.properties.PropertyFile;
import org.jabylon.properties.PropertyFileDescriptor;

public class PropertyFileAnalyzer {
    public List<Document> createDocuments(PropertyFileDescriptor descriptor) {
        PropertyFile file = descriptor.loadProperties();
        ArrayList<Document> documents = new ArrayList<Document>(file.getProperties().size());
        Map masterProperties = Collections.emptyMap();
        if (!descriptor.isMaster()) {
            PropertyFile masterFile = descriptor.getMaster().loadProperties();
            masterProperties = masterFile.asMap();
        }
        EList properties = file.getProperties();
        for (Property property : properties) {
            Field localeField;
            Document doc = new Document();
            ProjectLocale locale = descriptor.getProjectLocale();
            ProjectVersion version = (ProjectVersion)locale.getParent();
            Project project = (Project)version.getParent();
            Field projectField = new Field("project", project.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)projectField);
            Field versionField = new Field("version", version.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)versionField);
            if (locale.isMaster()) {
                localeField = new Field("locale", "master", Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add((Fieldable)localeField);
            } else if (locale.getLocale() != null) {
                localeField = new Field("locale", locale.getLocale().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add((Fieldable)localeField);
                if (masterProperties.get(property.getKey()) != null && ((Property)masterProperties.get(property.getKey())).getValue() != null) {
                    Field masterValueField = new Field("masterValue", ((Property)masterProperties.get(property.getKey())).getValue(), Field.Store.YES, Field.Index.ANALYZED);
                    doc.add((Fieldable)masterValueField);
                }
                if (masterProperties.get(property.getKey()) != null && ((Property)masterProperties.get(property.getKey())).getComment() != null) {
                    Field masterCommentField = new Field("masterComment", ((Property)masterProperties.get(property.getKey())).getComment(), Field.Store.YES, Field.Index.ANALYZED);
                    doc.add((Fieldable)masterCommentField);
                }
            }
            Field uriField = new Field("uri", descriptor.getLocation().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)uriField);
            Field pathField = new Field("path", descriptor.fullPath().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)pathField);
            CDOID cdoID = descriptor.cdoID();
            StringBuilder builder = new StringBuilder();
            CDOIDUtil.write((StringBuilder)builder, (CDOID)cdoID);
            Field idField = new Field("cdoID", builder.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)idField);
            Field comment = new Field("comment", this.nullSafe(property.getComment()), Field.Store.YES, Field.Index.ANALYZED);
            doc.add((Fieldable)comment);
            Field key = new Field("key", this.nullSafe(property.getKey()), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)key);
            Field analyzedKey = new Field("key", this.nullSafe(property.getKey()), Field.Store.YES, Field.Index.ANALYZED);
            doc.add((Fieldable)analyzedKey);
            Field value = new Field("value", this.nullSafe(property.getValue()), Field.Store.YES, Field.Index.ANALYZED);
            doc.add((Fieldable)value);
            String templateLocation = descriptor.getMaster() == null ? "" : descriptor.getMaster().getLocation().toString();
            Field templateLoc = new Field("templatePath", templateLocation, Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)templateLoc);
            documents.add(doc);
        }
        return documents;
    }

    private String nullSafe(String s) {
        return s == null ? "" : s;
    }
}

