/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.index.properties.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.LockObtainFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.common.notify.Notification;
import org.jabylon.index.properties.IndexActivator;
import org.jabylon.index.properties.impl.DocumentTuple;
import org.jabylon.index.properties.impl.PropertyFileAnalyzer;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.resources.changes.PropertiesListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PropertyIndex
extends Job
implements PropertiesListener {
    private static final Logger logger = LoggerFactory.getLogger(PropertyIndex.class);
    BlockingQueue<DocumentTuple> writes = new ArrayBlockingQueue<DocumentTuple>(50);

    public PropertyIndex() {
        super("Index Job");
    }

    public void propertyFileAdded(PropertyFileDescriptor descriptor, boolean autoSync) {
        PropertyFileAnalyzer analyzer = new PropertyFileAnalyzer();
        List<Document> documents = analyzer.createDocuments(descriptor);
        try {
            this.writes.put(new DocumentTuple(documents));
            this.schedule();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted", (Throwable)e);
        }
    }

    public void propertyFileDeleted(PropertyFileDescriptor descriptor, boolean autoSync) {
        try {
            this.writes.put(new DocumentTuple(descriptor));
            this.schedule();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted", (Throwable)e);
        }
    }

    public void propertyFileModified(PropertyFileDescriptor descriptor, List<Notification> changes, boolean autoSync) {
        PropertyFileAnalyzer analyzer = new PropertyFileAnalyzer();
        List<Document> documents = analyzer.createDocuments(descriptor);
        try {
            this.writes.put(new DocumentTuple(descriptor, documents));
            this.schedule();
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IndexWriter writer = null;
        try {
            DocumentTuple documentTuple;
            writer = IndexActivator.getDefault().obtainIndexWriter();
            block34: while ((documentTuple = this.writes.poll(2L, TimeUnit.MINUTES)) != null) {
                List<Document> documents = documentTuple.getDocuments();
                switch (documentTuple.getAction()) {
                    case CREATE: {
                        for (Document document : documents) {
                            writer.addDocument(document);
                        }
                        continue block34;
                    }
                    case DELETE: {
                        StringBuilder builder = new StringBuilder();
                        CDOIDUtil.write((StringBuilder)builder, (CDOID)documentTuple.getDescriptor().cdoID());
                        writer.deleteDocuments(new Term("cdoID", builder.toString()));
                        break;
                    }
                    case REPLACE: {
                        writer.deleteDocuments(new Term("path", documentTuple.getDescriptor().fullPath().toString()));
                        for (Document document : documents) {
                            writer.addDocument(document);
                        }
                        continue block34;
                    }
                }
            }
            writer.commit();
        }
        catch (CorruptIndexException e) {
            logger.error("Exception while indexing", (Throwable)e);
        }
        catch (LockObtainFailedException e) {
            logger.error("Exception while indexing", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception while indexing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for new index events", (Throwable)e);
        }
        finally {
            try {
                IndexActivator.getDefault().returnIndexWriter(writer);
            }
            catch (CorruptIndexException e) {
                logger.error("Exception while closing index writer", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Exception while closing index writer", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return IndexWriter.class == family;
    }
}

