/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.index.properties.impl;

import java.io.IOException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.common.resolver.URIResolver;
import org.jabylon.index.properties.IndexActivator;
import org.jabylon.index.properties.QueryService;
import org.jabylon.index.properties.SearchResult;
import org.jabylon.index.properties.jobs.impl.ReorgIndexJob;
import org.jabylon.properties.Project;
import org.jabylon.properties.ProjectLocale;
import org.jabylon.properties.ProjectVersion;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.ResourceFolder;
import org.jabylon.properties.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class QueryServiceImpl
implements QueryService {
    private static final Logger logger = LoggerFactory.getLogger(QueryServiceImpl.class);
    @Reference
    private URIResolver uriResolver;
    private volatile IndexSearcher searcher;
    private volatile IndexReader reader;
    @Reference
    private RepositoryConnector RepositoryConnector;

    @Deactivate
    public void deactivate() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.searcher != null) {
                this.searcher.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to close the index", (Throwable)e);
        }
    }

    public void bindUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void unbindUriResolver(URIResolver uriResolver) {
        this.uriResolver = null;
    }

    public void bindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.RepositoryConnector = repositoryConnector;
    }

    public void unbindRepositoryConnector(RepositoryConnector repositoryConnector) {
        this.RepositoryConnector = repositoryConnector;
    }

    @Override
    public SearchResult search(String search, String scopeURI) {
        search = search.toLowerCase();
        Query q = this.constructQuery(this.uriResolver.resolve(scopeURI), search);
        return this.search(q, 1000);
    }

    private Query constructQuery(Object scope, String search) {
        BooleanQuery query = new BooleanQuery();
        if (!(query instanceof Workspace)) {
            if (scope instanceof Project) {
                Project project = (Project)scope;
                query.add((Query)this.createProjectQuery(project), BooleanClause.Occur.MUST);
            } else if (scope instanceof ProjectVersion) {
                ProjectVersion version = (ProjectVersion)scope;
                query.add((Query)this.createProjectQuery((Project)version.getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createVersionQuery(version), BooleanClause.Occur.MUST);
            } else if (scope instanceof ProjectLocale) {
                ProjectLocale locale = (ProjectLocale)scope;
                query.add((Query)this.createProjectQuery((Project)((ProjectVersion)locale.getParent()).getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createVersionQuery((ProjectVersion)locale.getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createLocaleQuery(locale), BooleanClause.Occur.MUST);
            } else if (scope instanceof ResourceFolder) {
                ResourceFolder folder = (ResourceFolder)scope;
                ProjectLocale locale = folder.getProjectLocale();
                query.add((Query)this.createProjectQuery((Project)((ProjectVersion)locale.getParent()).getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createVersionQuery((ProjectVersion)locale.getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createLocaleQuery(locale), BooleanClause.Occur.MUST);
                query.add((Query)new PrefixQuery(new Term("path", folder.fullPath().path())), BooleanClause.Occur.MUST);
            } else if (scope instanceof PropertyFileDescriptor) {
                PropertyFileDescriptor descriptor = (PropertyFileDescriptor)scope;
                query.add((Query)this.createProjectQuery((Project)((ProjectVersion)descriptor.getProjectLocale().getParent()).getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createVersionQuery((ProjectVersion)descriptor.getProjectLocale().getParent()), BooleanClause.Occur.MUST);
                query.add((Query)this.createLocaleQuery(descriptor.getProjectLocale()), BooleanClause.Occur.MUST);
                query.add((Query)this.createDescriptorQuery(descriptor), BooleanClause.Occur.MUST);
            }
        }
        MultiFieldQueryParser queryParser = new MultiFieldQueryParser(Version.LUCENE_35, new String[]{"comment", "key", "analyzedkey", "value", "masterValue", "masterComment"}, (Analyzer)new StandardAnalyzer(Version.LUCENE_35));
        try {
            Query userQuery = queryParser.parse(search);
            query.add(userQuery, BooleanClause.Occur.MUST);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        query.add((Query)new TermQuery(new Term("locale", "master")), BooleanClause.Occur.MUST_NOT);
        return query;
    }

    private TermQuery createLocaleQuery(ProjectLocale locale) {
        return new TermQuery(new Term("locale", locale.getLocale().toString()));
    }

    private TermQuery createVersionQuery(ProjectVersion version) {
        return new TermQuery(new Term("version", version.getName()));
    }

    private TermQuery createProjectQuery(Project project) {
        TermQuery query = new TermQuery(new Term("project", project.getName()));
        return query;
    }

    private TermQuery createDescriptorQuery(PropertyFileDescriptor descriptor) {
        return new TermQuery(new Term("path", descriptor.fullPath().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult search(Query query, int maxHits) {
        Directory directory = IndexActivator.getDefault().getOrCreateDirectory();
        try {
            Object newReader;
            if (this.reader == null) {
                QueryServiceImpl queryServiceImpl = this;
                synchronized (queryServiceImpl) {
                    if (this.reader == null) {
                        this.reader = IndexReader.open((Directory)directory);
                    }
                }
            } else {
                newReader = IndexReader.openIfChanged((IndexReader)this.reader, (boolean)true);
                if (newReader != this.reader && newReader != null) {
                    this.reader.close();
                    this.reader = newReader;
                    if (this.searcher != null) {
                        this.searcher.close();
                    }
                    this.searcher = null;
                }
            }
            if (this.searcher == null) {
                newReader = this;
                synchronized (newReader) {
                    if (this.searcher == null) {
                        this.searcher = new IndexSearcher(this.reader);
                    }
                }
            }
            TopDocs result = this.searcher.search(query, maxHits);
            return new SearchResult(this.searcher, result);
        }
        catch (CorruptIndexException e) {
            logger.error("Error during search " + query, (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error during search " + query, (Throwable)e);
        }
        return null;
    }

    @Override
    public PropertyFileDescriptor getDescriptor(Document doc) {
        String cdoID = doc.get("cdoID");
        CDOID id = CDOIDUtil.read((String)cdoID);
        CDOObject object = null;
        try {
            object = this.uriResolver.resolve(id);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        if (object instanceof PropertyFileDescriptor) {
            PropertyFileDescriptor descriptor = (PropertyFileDescriptor)object;
            return descriptor;
        }
        return null;
    }

    @Override
    public void rebuildIndex(IProgressMonitor monitor) throws CorruptIndexException, IOException {
        ReorgIndexJob.indexWorkspace(this.RepositoryConnector, monitor);
    }
}

