/*
 * Decompiled with CFR 0.152.
 */
package org.jabylon.index.properties.jobs.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.jabylon.cdo.connector.RepositoryConnector;
import org.jabylon.index.properties.IndexActivator;
import org.jabylon.index.properties.impl.PropertyFileAnalyzer;
import org.jabylon.properties.Project;
import org.jabylon.properties.PropertyFileDescriptor;
import org.jabylon.properties.Workspace;
import org.jabylon.scheduler.JobExecution;
import org.jabylon.scheduler.JobUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=true, immediate=true)
@Service
public class ReorgIndexJob
implements JobExecution {
    public static final String JOB_ID = "job.reorg.index";
    private static final Logger logger = LoggerFactory.getLogger(ReorgIndexJob.class);
    @Property(value={"true"}, name="active")
    public static final String DEFAULT_ACTIVE = "true";
    @Property(value={"0 0 2 * * ?"}, name="schedule")
    public static final String DEFAULT_SCHEDULE = "0 0 2 * * ?";
    @Property(value={"%reorg.job.name"}, name="name")
    private String NAME = "name";
    @Property(value={"%reorg.job.description"}, name="description")
    private String DESCRIPTION = "description";

    public void run(IProgressMonitor monitor, Map<String, Object> jobContext) throws Exception {
        RepositoryConnector connector = JobUtil.getRepositoryConnector(jobContext);
        ReorgIndexJob.indexWorkspace(connector, monitor);
    }

    public boolean retryOnError() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void indexWorkspace(Workspace workspace, IndexWriter writer, IProgressMonitor monitor) throws CorruptIndexException, IOException {
        EList projects = workspace.getChildren();
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Rebuilding Index", (int)(projects.size() * 10));
        PropertyFileAnalyzer analyzer = new PropertyFileAnalyzer();
        try {
            for (Project project : projects) {
                SubMonitor mon = submon.newChild(10, 0);
                mon.beginTask("", 100);
                String message = "Indexing {0}";
                submon.setTaskName(MessageFormat.format(message, project.getName()));
                TreeIterator contents = project.eAllContents();
                while (contents.hasNext()) {
                    ReorgIndexJob.checkCanceled(monitor);
                    EObject next = (EObject)contents.next();
                    if (!(next instanceof PropertyFileDescriptor)) continue;
                    PropertyFileDescriptor descriptor = (PropertyFileDescriptor)next;
                    mon.subTask(descriptor.getLocation().toString());
                    List<Document> documents = analyzer.createDocuments(descriptor);
                    for (Document document : documents) {
                        writer.addDocument(document);
                    }
                    mon.worked(1);
                }
                mon.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void indexWorkspace(RepositoryConnector connector, IProgressMonitor monitor) throws CorruptIndexException, IOException {
        long time = System.currentTimeMillis();
        logger.info("Reorg of search index started");
        IndexWriter writer = null;
        CDONet4jSession session = null;
        try {
            writer = IndexActivator.getDefault().obtainIndexWriter();
            writer.deleteAll();
            session = connector.createSession();
            CDOView view = session.openView();
            CDOResource resource = view.getResource("workspace");
            Workspace workspace = (Workspace)resource.getContents().get(0);
            ReorgIndexJob.indexWorkspace(workspace, writer, monitor);
            writer.commit();
        }
        catch (OutOfMemoryError error) {
            logger.error("Out of memory during index reorg", (Throwable)error);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Exception during index reorg. Rolling back", (Throwable)e);
            if (writer != null) {
                writer.rollback();
            }
            throw new IllegalStateException("Failed to write index", e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            if (session != null) {
                session.close();
            }
            IndexActivator.getDefault().returnIndexWriter(writer);
        }
        long duration = (System.currentTimeMillis() - time) / 1000L;
        logger.info("Search Index Reorg finished. Took {} seconds", (Object)duration);
    }

    public String getID() {
        return JOB_ID;
    }
}

