/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOURIUtil {
    public static final String PROTOCOL_NAME = "cdo";
    public static final char SEGMENT_SEPARATOR_CHAR = '/';
    public static final String SEGMENT_SEPARATOR = new String(new char[]{'/'});

    static {
        CDOUtil.registerResourceFactory(null);
    }

    private CDOURIUtil() {
    }

    @Deprecated
    public static void validateURI(URI uri) throws InvalidURIException {
    }

    public static String extractRepositoryUUID(URI uri) {
        try {
            if (!uri.hasAuthority()) {
                throw new InvalidURIException(uri);
            }
            return uri.authority();
        }
        catch (InvalidURIException ex) {
            return null;
        }
    }

    public static String[] extractResourceFolderAndName(URI uri) throws InvalidURIException {
        String path = CDOURIUtil.extractResourcePath(uri);
        int lastSeparator = path.lastIndexOf(47);
        if (lastSeparator == -1) {
            String[] stringArray = new String[2];
            stringArray[1] = path;
            return stringArray;
        }
        String folder = path.substring(0, lastSeparator);
        String name = path.substring(lastSeparator + 1);
        return new String[]{folder, name};
    }

    public static String extractResourcePath(URI uri) throws InvalidURIException {
        if (!PROTOCOL_NAME.equals(uri.scheme())) {
            CDOURIData data = new CDOURIData(uri);
            return data.getResourcePath().toPortableString();
        }
        String path = uri.path();
        if (path == null) {
            return SEGMENT_SEPARATOR;
        }
        return path;
    }

    public static URI createResourceURI(String repositoryUUID, String path) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PROTOCOL_NAME);
        stringBuilder.append(":");
        if (repositoryUUID != null) {
            stringBuilder.append("//");
            stringBuilder.append(repositoryUUID);
        }
        if (!SEGMENT_SEPARATOR.equals(path)) {
            if (path.charAt(0) != '/') {
                stringBuilder.append('/');
            }
            stringBuilder.append(path);
        }
        return URI.createURI((String)stringBuilder.toString());
    }

    public static URI createResourceURI(CDOView view, String path) {
        return CDOURIUtil.createResourceURI(view == null ? null : view.getSession(), path);
    }

    public static URI createResourceURI(CDOSession session, String path) {
        return CDOURIUtil.createResourceURI(session == null ? null : session.getRepositoryInfo().getUUID(), path);
    }

    public static CDOID convertExternalCDOID(URI baseURI, CDOID newCDOID) {
        StringBuilder builder = new StringBuilder();
        CDOIDUtil.write((StringBuilder)builder, (CDOID)newCDOID);
        baseURI = baseURI.trimFragment().appendFragment(builder.toString());
        return CDOIDUtil.createExternal((String)baseURI.toString());
    }

    public static List<String> analyzePath(URI uri) {
        String path = CDOURIUtil.extractResourcePath(uri);
        return CDOURIUtil.analyzePath(path);
    }

    public static List<String> analyzePath(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, SEGMENT_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (name == null) continue;
            segments.add(name);
        }
        return segments;
    }

    public static Map<String, String> getParameters(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String key;
            String parameter = tokenizer.nextToken();
            if (StringUtil.isEmpty((String)parameter)) continue;
            int pos = parameter.indexOf(61);
            if (pos == -1) {
                key = parameter.trim();
                result.put(key, "");
                continue;
            }
            key = parameter.substring(0, pos).trim();
            String value = parameter.substring(pos + 1);
            result.put(key, value);
        }
        return result;
    }
}

